/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.delegate.event.FlowableEngineEvent;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.Flowable5Util;

public class ErrorThrowingEventListener
extends BaseDelegateEventListener {
    protected String errorCode;

    public void onEvent(FlowableEvent event) {
        if (this.isValidEvent(event) && event instanceof FlowableEngineEvent) {
            FlowableEngineEvent engineEvent = (FlowableEngineEvent)event;
            CommandContext commandContext = Context.getCommandContext();
            if (engineEvent.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, engineEvent.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.throwErrorEvent(event);
                return;
            }
            ExecutionEntity execution = null;
            if (engineEvent.getExecutionId() != null) {
                execution = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(engineEvent.getExecutionId());
            }
            if (execution == null) {
                throw new FlowableException("No execution context active and event is not related to an execution. No compensation event can be thrown.");
            }
            try {
                ErrorPropagation.propagateError(this.errorCode, (DelegateExecution)execution);
            }
            catch (Exception e) {
                throw new FlowableException("Error while propagating error-event", (Throwable)e);
            }
        }
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isFailOnException() {
        return true;
    }
}

