/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.delegate.event.FlowableEngineEvent;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.engine.impl.persistence.entity.MessageEventSubscriptionEntity;

public class MessageThrowingEventListener
extends BaseDelegateEventListener {
    protected String messageName;
    protected Class<?> entityClass;

    public void onEvent(FlowableEvent event) {
        if (this.isValidEvent(event) && event instanceof FlowableEngineEvent) {
            FlowableEngineEvent engineEvent = (FlowableEngineEvent)event;
            if (engineEvent.getProcessInstanceId() == null) {
                throw new FlowableIllegalArgumentException("Cannot throw process-instance scoped message, since the dispatched event is not part of an ongoing process instance");
            }
            EventSubscriptionEntityManager eventSubscriptionEntityManager = Context.getCommandContext().getEventSubscriptionEntityManager();
            List<MessageEventSubscriptionEntity> subscriptionEntities = eventSubscriptionEntityManager.findMessageEventSubscriptionsByProcessInstanceAndEventName(engineEvent.getProcessInstanceId(), this.messageName);
            for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionEntities) {
                eventSubscriptionEntityManager.eventReceived(eventSubscriptionEntity, null, false);
            }
        }
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public boolean isFailOnException() {
        return true;
    }
}

