/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.calendar;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.runtime.ClockReader;
import org.flowable.engine.impl.calendar.AdvancedSchedulerResolver;
import org.flowable.engine.impl.calendar.AdvancedSchedulerResolverWithTimeZone;
import org.flowable.engine.impl.calendar.AdvancedSchedulerResolverWithoutTimeZone;
import org.flowable.engine.impl.calendar.CycleBusinessCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedCycleBusinessCalendar
extends CycleBusinessCalendar {
    private Integer defaultScheduleVersion;
    private static final Integer DEFAULT_VERSION = 2;
    private static final Logger logger = LoggerFactory.getLogger(AdvancedCycleBusinessCalendar.class);
    private static final Map<Integer, AdvancedSchedulerResolver> resolvers = new ConcurrentHashMap<Integer, AdvancedSchedulerResolver>();

    public AdvancedCycleBusinessCalendar(ClockReader clockReader) {
        super(clockReader);
    }

    public AdvancedCycleBusinessCalendar(ClockReader clockReader, Integer defaultScheduleVersion) {
        this(clockReader);
        this.defaultScheduleVersion = defaultScheduleVersion;
    }

    public Integer getDefaultScheduleVersion() {
        return this.defaultScheduleVersion == null ? DEFAULT_VERSION : this.defaultScheduleVersion;
    }

    public void setDefaultScheduleVersion(Integer defaultScheduleVersion) {
        this.defaultScheduleVersion = defaultScheduleVersion;
    }

    @Override
    public Date resolveDuedate(String duedateDescription, int maxIterations) {
        logger.info("Resolving Due Date: {}", (Object)duedateDescription);
        String timeZone = this.getValueFrom("DSTZONE", duedateDescription);
        String version = this.getValueFrom("VER", duedateDescription);
        duedateDescription = this.removeValueFrom("VER", this.removeValueFrom("START", this.removeValueFrom("DSTZONE", duedateDescription))).trim();
        try {
            logger.info("Base Due Date: {}", (Object)duedateDescription);
            Date date = resolvers.get(version == null ? this.getDefaultScheduleVersion() : Integer.valueOf(version)).resolve(duedateDescription, this.clockReader, timeZone == null ? this.clockReader.getCurrentTimeZone() : TimeZone.getTimeZone(timeZone));
            logger.info("Calculated Date: {}", date == null ? "Will Not Run Again" : date);
            return date;
        }
        catch (Exception e) {
            throw new FlowableIllegalArgumentException("Cannot parse duration", (Throwable)e);
        }
    }

    private String getValueFrom(String field, String duedateDescription) {
        int fieldIndex = duedateDescription.indexOf(field + ":");
        if (fieldIndex > -1) {
            int nextWhiteSpace = duedateDescription.indexOf(32, fieldIndex);
            fieldIndex += field.length() + 1;
            if (nextWhiteSpace > -1) {
                return duedateDescription.substring(fieldIndex, nextWhiteSpace);
            }
            return duedateDescription.substring(fieldIndex);
        }
        return null;
    }

    private String removeValueFrom(String field, String duedateDescription) {
        int fieldIndex = duedateDescription.indexOf(field + ":");
        if (fieldIndex > -1) {
            int nextWhiteSpace = duedateDescription.indexOf(32, fieldIndex);
            if (nextWhiteSpace > -1) {
                return duedateDescription.replace(duedateDescription.substring(fieldIndex, nextWhiteSpace), "");
            }
            return duedateDescription.substring(0, fieldIndex);
        }
        return duedateDescription;
    }

    static {
        resolvers.put(1, new AdvancedSchedulerResolverWithoutTimeZone());
        resolvers.put(2, new AdvancedSchedulerResolverWithTimeZone());
    }
}

