/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.JobInfoEntity;
import org.flowable.engine.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExecuteAsyncJobCmd.class);
    protected String jobId;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;

    public ExecuteAsyncJobCmd(String jobId) {
        this.jobId = jobId;
    }

    public ExecuteAsyncJobCmd(String jobId, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.jobId = jobId;
        this.jobEntityManager = jobEntityManager;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.jobEntityManager == null) {
            this.jobEntityManager = commandContext.getJobEntityManager();
        }
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        JobInfoEntity job = (JobInfoEntity)this.jobEntityManager.findById(this.jobId);
        if (job == null) {
            log.debug("Job does not exist anymore and will not be executed. It has most likely been deleted as part of another concurrent part of the process instance.");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Executing async job {}", (Object)job.getId());
        }
        commandContext.getJobManager().execute(job);
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_EXECUTION_SUCCESS, job));
        }
        return null;
    }
}

