/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.IdentityService;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.task.IdentityLink;
import org.flowable.idm.api.Group;

public class GetPotentialStarterGroupsCmd
implements Command<List<Group>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetPotentialStarterGroupsCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public List<Group> execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find process definition with id " + this.processDefinitionId, ProcessDefinition.class);
        }
        IdentityService identityService = commandContext.getProcessEngineConfiguration().getIdentityService();
        ArrayList<String> groupIds = new ArrayList<String>();
        List<IdentityLinkEntity> identityLinks = processDefinition.getIdentityLinks();
        for (IdentityLink identityLink : identityLinks) {
            if (identityLink.getGroupId() == null || identityLink.getGroupId().length() <= 0 || groupIds.contains(identityLink.getGroupId())) continue;
            groupIds.add(identityLink.getGroupId());
        }
        if (groupIds.size() > 0) {
            return identityService.createGroupQuery().groupIds(groupIds).list();
        }
        return new ArrayList<Group>();
    }
}

