/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockExclusiveJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(UnlockExclusiveJobCmd.class);
    protected Job job;

    public UnlockExclusiveJobCmd(Job job) {
        this.job = job;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ExecutionEntity execution;
        if (this.job == null) {
            throw new FlowableIllegalArgumentException("job is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Unlocking exclusive job {}", (Object)this.job.getId());
        }
        if (this.job.isExclusive() && this.job.getProcessInstanceId() != null && (execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.job.getProcessInstanceId())) != null) {
            commandContext.getExecutionEntityManager().clearProcessInstanceLockTime(execution.getId());
        }
        return null;
    }
}

