/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history;

import org.flowable.engine.common.api.FlowableIllegalArgumentException;

public enum HistoryLevel {
    NONE("none"),
    ACTIVITY("activity"),
    AUDIT("audit"),
    FULL("full");

    private String key;

    private HistoryLevel(String key) {
        this.key = key;
    }

    public static HistoryLevel getHistoryLevelForKey(String key) {
        for (HistoryLevel level : HistoryLevel.values()) {
            if (!level.key.equals(key)) continue;
            return level;
        }
        throw new FlowableIllegalArgumentException("Illegal value for history-level: " + key);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isAtLeast(HistoryLevel level) {
        return this.compareTo(level) >= 0;
    }
}

