/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsUnfinishedHistoricActivityHistoryJsonTransformer;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;

public class ActivityEndHistoryJsonTransformer
extends AbstractNeedsUnfinishedHistoricActivityHistoryJsonTransformer {
    @Override
    public String getType() {
        return "activity-end";
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String activityId;
        String executionId = this.getStringFromJson(historicalData, "executionId");
        HistoricActivityInstanceEntity historicActivityInstanceEntity = this.findUnfinishedHistoricActivityInstance(commandContext, executionId, activityId = this.getStringFromJson(historicalData, "activityId"));
        if (historicActivityInstanceEntity != null) {
            Date endTime = this.getDateFromJson(historicalData, "endTime");
            historicActivityInstanceEntity.setEndTime(endTime);
            historicActivityInstanceEntity.setDeleteReason(this.getStringFromJson(historicalData, "deleteReason"));
            Date startTime = historicActivityInstanceEntity.getStartTime();
            if (startTime != null && endTime != null) {
                historicActivityInstanceEntity.setDurationInMillis(endTime.getTime() - startTime.getTime());
            }
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstanceEntity));
        }
    }
}

