/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsTaskHistoryJsonTransformer;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.engine.impl.persistence.entity.HistoricIdentityLinkEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;

public class TaskAssigneeChangedHistoryJsonTransformer
extends AbstractNeedsTaskHistoryJsonTransformer {
    @Override
    public String getType() {
        return "task-assignee-changed";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        String activityAssigneeHandled = this.getStringFromJson(historicalData, "activityAssigneeHandled");
        if (activityAssigneeHandled != null && Boolean.valueOf(activityAssigneeHandled).booleanValue()) {
            return super.isApplicable(historicalData, commandContext);
        }
        String executionId = this.getStringFromJson(historicalData, "executionId");
        if (StringUtils.isNotEmpty((CharSequence)executionId)) {
            return super.isApplicable(historicalData, commandContext) && this.historicActivityInstanceExistsForDataIncludingFinished(historicalData, commandContext);
        }
        return super.isApplicable(historicalData, commandContext);
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String taskId;
        String activityAssigneeHandled;
        String assignee = this.getStringFromJson(historicalData, "assignee");
        String executionId = this.getStringFromJson(historicalData, "executionId");
        String activityId = this.getStringFromJson(historicalData, "activityId");
        if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)activityId) && ((activityAssigneeHandled = this.getStringFromJson(historicalData, "activityAssigneeHandled")) == null || !Boolean.valueOf(activityAssigneeHandled).booleanValue())) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = this.findHistoricActivityInstance(commandContext, executionId, activityId);
            if (historicActivityInstanceEntity == null) {
                return;
            }
            historicActivityInstanceEntity.setAssignee(assignee);
        }
        if (StringUtils.isNotEmpty((CharSequence)(taskId = this.getStringFromJson(historicalData, "id")))) {
            HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getProcessEngineConfiguration().getHistoricIdentityLinkEntityManager();
            HistoricIdentityLinkEntity historicIdentityLinkEntity = (HistoricIdentityLinkEntity)historicIdentityLinkEntityManager.create();
            historicIdentityLinkEntity.setTaskId(taskId);
            historicIdentityLinkEntity.setType("assignee");
            historicIdentityLinkEntity.setUserId(assignee);
            historicIdentityLinkEntity.setCreateTime(this.getDateFromJson(historicalData, "createTime"));
            historicIdentityLinkEntityManager.insert(historicIdentityLinkEntity, false);
        }
    }
}

