/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.profiler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.flowable.engine.cfg.ProcessEngineConfigurator;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.interceptor.CommandInterceptor;
import org.flowable.engine.test.profiler.ProfileSession;
import org.flowable.engine.test.profiler.ProfilingDbSqlSessionFactory;
import org.flowable.engine.test.profiler.TotalExecutionTimeCommandInterceptor;

public class FlowableProfiler
implements ProcessEngineConfigurator {
    protected static FlowableProfiler INSTANCE = new FlowableProfiler();
    protected ProfileSession currentProfileSession;
    protected List<ProfileSession> profileSessions = new ArrayList<ProfileSession>();

    public static FlowableProfiler getInstance() {
        return INSTANCE;
    }

    @Override
    public void beforeInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ArrayList<CommandInterceptor> interceptors = new ArrayList<CommandInterceptor>();
        interceptors.add(new TotalExecutionTimeCommandInterceptor());
        processEngineConfiguration.setCustomPreCommandInterceptors(interceptors);
        processEngineConfiguration.setDbSqlSessionFactory(new ProfilingDbSqlSessionFactory());
    }

    @Override
    public void configure(ProcessEngineConfigurationImpl processEngineConfiguration) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public void reset() {
        if (this.currentProfileSession != null) {
            this.stopCurrentProfileSession();
        }
        this.currentProfileSession = null;
        this.profileSessions.clear();
    }

    public void startProfileSession(String name) {
        this.currentProfileSession = new ProfileSession(name);
        this.profileSessions.add(this.currentProfileSession);
    }

    public void stopCurrentProfileSession() {
        this.currentProfileSession.setEndTime(new Date());
        this.currentProfileSession = null;
    }

    public ProfileSession getCurrentProfileSession() {
        return this.currentProfileSession;
    }

    public void setCurrentProfileSession(ProfileSession currentProfileSession) {
        this.currentProfileSession = currentProfileSession;
    }

    public List<ProfileSession> getProfileSessions() {
        return this.profileSessions;
    }

    public void setProfileSessions(List<ProfileSession> profileSessions) {
        this.profileSessions = profileSessions;
    }
}

