/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CorrelationUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EventInstanceBpmnUtil;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;

public class BoundaryEventRegistryEventActivityBehavior
extends BoundaryEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String eventDefinitionKey;

    public BoundaryEventRegistryEventActivityBehavior(String eventDefinitionKey, boolean interrupting) {
        super(interrupting);
        this.eventDefinitionKey = eventDefinitionKey;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        EventModel eventModel = this.getEventModel(execution);
        EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)CommandContextUtil.getEventSubscriptionService(commandContext).createEventSubscriptionBuilder().eventType(eventModel.getKey()).executionId(executionEntity.getId()).processInstanceId(executionEntity.getProcessInstanceId()).activityId(executionEntity.getCurrentActivityId()).processDefinitionId(executionEntity.getProcessDefinitionId()).scopeType("bpmn").tenantId(executionEntity.getTenantId()).configuration(CorrelationUtil.getCorrelationKey("eventCorrelationParameter", commandContext, executionEntity)).create();
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
        executionEntity.getEventSubscriptions().add(eventSubscription);
    }

    protected EventModel getEventModel(DelegateExecution execution) {
        EventModel eventModel = null;
        eventModel = Objects.equals("", execution.getTenantId()) ? CommandContextUtil.getEventRepositoryService().getEventModelByKey(this.eventDefinitionKey) : CommandContextUtil.getEventRepositoryService().getEventModelByKey(this.eventDefinitionKey, execution.getTenantId());
        return eventModel;
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
        Object eventInstance = execution.getTransientVariables().get("eventInstance");
        if (eventInstance instanceof EventInstance) {
            EventInstanceBpmnUtil.handleEventInstanceOutParameters(execution, (BaseElement)boundaryEvent, (EventInstance)eventInstance);
        }
        if (boundaryEvent.isCancelActivity()) {
            EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService();
            List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
            CommandContext commandContext = Context.getCommandContext();
            EventModel eventModel = this.getEventModel(commandContext, executionEntity);
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                if (!Objects.equals(eventModel.getKey(), eventSubscription.getEventType())) continue;
                eventSubscriptionService.deleteEventSubscription(eventSubscription);
                CountingEntityUtil.handleDeleteEventSubscriptionEntityCount((EventSubscription)eventSubscription);
            }
        }
        super.trigger(executionEntity, triggerName, triggerData);
    }

    protected EventModel getEventModel(CommandContext commandContext, ExecutionEntity executionEntity) {
        EventModel eventModel;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        String key = null;
        if (StringUtils.isNotEmpty((CharSequence)this.eventDefinitionKey)) {
            Expression expression = processEngineConfiguration.getExpressionManager().createExpression(this.eventDefinitionKey);
            key = expression.getValue((VariableContainer)executionEntity).toString();
        }
        if ((eventModel = this.getEventModel(executionEntity)) == null) {
            throw new FlowableException("Could not find event model for key " + key);
        }
        return eventModel;
    }
}

