/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.rest.service.api.repository.BaseProcessDefinitionResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Definitions"}, description="Manage Process Definitions", authorizations={@Authorization(value="basicAuth")})
public class ProcessDefinitionImageResource
extends BaseProcessDefinitionResource {
    @ApiOperation(value="Get a process definition image", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the process-definitions are returned"), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @GetMapping(value={"/repository/process-definitions/{processDefinitionId}/image"}, produces={"image/png"})
    public ResponseEntity<byte[]> getModelResource(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        InputStream imageStream = this.repositoryService.getProcessDiagram(processDefinition.getId());
        if (imageStream != null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Type", "image/png");
            try {
                return new ResponseEntity((Object)IOUtils.toByteArray((InputStream)imageStream), (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            catch (Exception e) {
                throw new FlowableException("Error reading image stream", (Throwable)e);
            }
        }
        throw new FlowableIllegalArgumentException("Process definition with id '" + processDefinition.getId() + "' has no image.");
    }
}

