/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.conf;

import java.util.Properties;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.flowable.ui.admin.domain.generator.MinimalDataGenerator;
import org.flowable.ui.admin.properties.FlowableAdminAppProperties;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;

@Configuration
public class DatabaseConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseConfiguration.class);
    protected static final String LIQUIBASE_CHANGELOG_PREFIX = "ACT_ADM_";
    @Autowired
    private FlowableAdminAppProperties env;
    @Autowired
    private ResourceLoader resourceLoader;

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        try {
            Properties properties = new Properties();
            properties.put("prefix", this.env.getDataSourcePrefix());
            sqlSessionFactoryBean.setConfigurationProperties(properties);
            sqlSessionFactoryBean.setMapperLocations(ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath:/META-INF/admin-mybatis-mappings/*.xml"));
            sqlSessionFactoryBean.afterPropertiesSet();
            return sqlSessionFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create sqlSessionFactory", e);
        }
    }

    @Bean(destroyMethod="clearCache")
    public SqlSessionTemplate SqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean(name={"liquibase"})
    public Liquibase liquibase(DataSource dataSource) {
        LOGGER.debug("Configuring Liquibase");
        Liquibase liquibase = null;
        try {
            JdbcConnection connection = new JdbcConnection(dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogLockTableName());
            liquibase = new Liquibase("META-INF/liquibase/flowable-admin-app-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update("flowable");
            Liquibase liquibase2 = liquibase;
            this.closeDatabase(liquibase);
            return liquibase2;
        }
        catch (Exception e) {
            try {
                throw new InternalServerErrorException("Error creating liquibase database");
            }
            catch (Throwable throwable) {
                this.closeDatabase(liquibase);
                throw throwable;
            }
        }
    }

    @Bean(name={"minimalDataGenerator"})
    public MinimalDataGenerator minimalDataGenerator() {
        return new MinimalDataGenerator();
    }

    private void closeDatabase(Liquibase liquibase) {
        Database database;
        if (liquibase != null && (database = liquibase.getDatabase()) != null) {
            try {
                database.close();
            }
            catch (DatabaseException e) {
                LOGGER.warn("Error closing database", (Throwable)e);
            }
        }
    }
}

