/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CmmnJobService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnJobService.class);
    @Autowired
    protected FlowableClientService clientUtil;

    public JsonNode listJobs(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        String jobType = null;
        String[] jobTypeParameter = parameterMap.get("jobType");
        if (jobTypeParameter != null && jobTypeParameter.length > 0) {
            jobType = jobTypeParameter[0];
        }
        String jobUrl = this.getJobUrl(jobType);
        URIBuilder builder = null;
        try {
            builder = new URIBuilder(jobUrl);
        }
        catch (Exception e) {
            LOGGER.error("Error building uri", (Throwable)e);
            throw new FlowableServiceException("Error building uri", e);
        }
        for (String name : parameterMap.keySet()) {
            if ("jobType".equals(name)) continue;
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getJob(ServerConfig serverConfig, String jobId, String jobType) {
        String jobUrl = this.getJobUrl(jobType);
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, jobUrl + jobId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public String getJobStacktrace(ServerConfig serverConfig, String jobId, String jobType) {
        String jobUrl = this.getJobUrl(jobType);
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, jobUrl + jobId + "/exception-stacktrace"));
        return this.clientUtil.executeRequestAsString((HttpUriRequest)get, serverConfig, 200);
    }

    public void executeJob(ServerConfig serverConfig, String jobId) {
        HttpPost post = this.clientUtil.createPost("management/jobs/" + jobId, serverConfig);
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.put("action", "execute");
        post.setEntity((HttpEntity)this.clientUtil.createStringEntity((JsonNode)node));
        this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)post, serverConfig, 204);
    }

    public void moveJob(ServerConfig serverConfig, String jobId, String jobType) {
        String jobUrl = this.getJobUrl(jobType);
        HttpPost post = this.clientUtil.createPost(jobUrl + jobId, serverConfig);
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.put("action", "move");
        post.setEntity((HttpEntity)this.clientUtil.createStringEntity((JsonNode)node));
        this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)post, serverConfig, 204);
    }

    public void deleteJob(ServerConfig serverConfig, String jobId, String jobType) {
        String jobUrl = this.getJobUrl(jobType);
        HttpDelete post = new HttpDelete(this.clientUtil.getServerUrl(serverConfig, jobUrl + jobId));
        this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)post, serverConfig, 204);
    }

    protected String getJobUrl(String jobType) {
        String jobUrl = null;
        jobUrl = "timerJob".equals(jobType) ? "cmmn-management/timer-jobs/" : ("suspendedJob".equals(jobType) ? "cmmn-management/suspended-jobs/" : ("deadletterJob".equals(jobType) ? "cmmn-management/deadletter-jobs/" : "cmmn-management/jobs/"));
        return jobUrl;
    }
}

