/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.AttachmentResponseInfo;
import org.flowable.ui.admin.service.ResponseInfo;
import org.flowable.ui.admin.service.engine.ServerConfigService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowableClientService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableClientService.class);
    protected static final String[] PAGING_AND_SORTING_PARAMETER_NAMES = new String[]{"sort", "order", "size"};
    public static final String DEFAULT_FLOWABLE_CONTEXT_ROOT = "flowable-rest";
    public static final String DEFAULT_FLOWABLE_REST_ROOT = "service";
    @Autowired
    protected ServerConfigService serverConfigService;
    @Autowired
    protected ObjectMapper objectMapper;

    public CloseableHttpClient getHttpClient(ServerConfig serverConfig) {
        return this.getHttpClient(serverConfig.getUserName(), this.serverConfigService.decrypt(serverConfig.getPassword()));
    }

    public CloseableHttpClient getHttpClient(String userName, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sslsf = new SSLConnectionSocketFactory(builder.build(), new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("Could not configure HTTP client to use SSL", (Throwable)e);
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (sslsf != null) {
            httpClientBuilder.setSSLSocketFactory(sslsf);
        }
        return httpClientBuilder.build();
    }

    public JsonNode executeRequest(HttpUriRequest request, ServerConfig serverConfig) {
        return this.executeRequest(request, serverConfig, 200);
    }

    public JsonNode executeRequest(HttpUriRequest request, ServerConfig serverConfig, int expectedStatusCode) {
        return this.executeRequest(request, serverConfig.getUserName(), this.serverConfigService.decrypt(serverConfig.getPassword()), expectedStatusCode);
    }

    public JsonNode executeRequest(HttpUriRequest request, String userName, String password) {
        return this.executeRequest(request, userName, password, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode executeRequest(HttpUriRequest request, String userName, String password, int expectedStatusCode) {
        String strResponse;
        Throwable throwable;
        CloseableHttpResponse response;
        FlowableServiceException exception;
        block33: {
            JsonNode jsonNode;
            CloseableHttpClient client;
            block34: {
                block35: {
                    JsonNode bodyNode;
                    boolean success;
                    exception = null;
                    client = this.getHttpClient(userName, password);
                    response = client.execute(request);
                    throwable = null;
                    InputStream responseContent = response.getEntity().getContent();
                    strResponse = IOUtils.toString((InputStream)responseContent, (String)"utf-8");
                    boolean bl = success = response.getStatusLine() != null && response.getStatusLine().getStatusCode() == expectedStatusCode;
                    if (!success) break block33;
                    jsonNode = bodyNode = this.objectMapper.readTree(strResponse);
                    if (response == null) break block34;
                    if (throwable == null) break block35;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block34;
                }
                response.close();
            }
            try {
                client.close();
                return jsonNode;
            }
            catch (Exception e) {
                LOGGER.warn("Error closing http client instance", (Throwable)e);
            }
            return jsonNode;
        }
        try {
            try {
                JsonNode bodyNode = null;
                try {
                    bodyNode = this.objectMapper.readTree(strResponse);
                }
                catch (Exception e) {
                    LOGGER.debug("Error parsing error message", (Throwable)e);
                }
                exception = new FlowableServiceException(this.extractError(bodyNode, "An error occurred while calling Flowable: " + response.getStatusLine()));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error consuming response from uri {}", (Object)request.getURI(), (Object)e);
            exception = this.wrapException(e, request);
        }
        if (exception == null) return null;
        throw exception;
    }

    public JsonNode executeDownloadRequest(HttpUriRequest request, HttpServletResponse httpResponse, ServerConfig serverConfig) {
        return this.executeDownloadRequest(request, httpResponse, serverConfig, 200);
    }

    public JsonNode executeDownloadRequest(HttpUriRequest request, HttpServletResponse httpResponse, ServerConfig serverConfig, int expectedStatusCode) {
        return this.executeDownloadRequest(request, httpResponse, serverConfig.getUserName(), this.serverConfigService.decrypt(serverConfig.getPassword()), expectedStatusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode executeDownloadRequest(HttpUriRequest request, HttpServletResponse httpResponse, String userName, String password, int expectedStatusCode) {
        Throwable throwable;
        CloseableHttpResponse response;
        FlowableServiceException exception;
        block33: {
            JsonNode jsonNode;
            CloseableHttpClient client;
            block34: {
                block35: {
                    boolean success;
                    exception = null;
                    client = this.getHttpClient(userName, password);
                    response = client.execute(request);
                    throwable = null;
                    boolean bl = success = response.getStatusLine() != null && response.getStatusLine().getStatusCode() == expectedStatusCode;
                    if (!success) break block33;
                    httpResponse.setHeader("Content-Disposition", response.getHeaders("Content-Disposition")[0].getValue());
                    response.getEntity().writeTo((OutputStream)httpResponse.getOutputStream());
                    jsonNode = null;
                    if (response == null) break block34;
                    if (throwable == null) break block35;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block34;
                }
                response.close();
            }
            try {
                client.close();
                return jsonNode;
            }
            catch (Exception e) {
                LOGGER.warn("Error closing http client instance", (Throwable)e);
            }
            return jsonNode;
        }
        try {
            try {
                JsonNode bodyNode = null;
                String strResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"utf-8");
                try {
                    bodyNode = this.objectMapper.readTree(strResponse);
                }
                catch (Exception e) {
                    LOGGER.debug("Error parsing error message", (Throwable)e);
                }
                exception = new FlowableServiceException(this.extractError(bodyNode, "An error occurred while calling Flowable: " + response.getStatusLine()));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error consuming response from uri {}", (Object)request.getURI(), (Object)e);
            exception = this.wrapException(e, request);
        }
        if (exception == null) return null;
        throw exception;
    }

    public AttachmentResponseInfo executeDownloadRequest(HttpUriRequest request, ServerConfig serverConfig) {
        return this.executeDownloadRequest(request, serverConfig, 200);
    }

    public AttachmentResponseInfo executeDownloadRequest(HttpUriRequest request, ServerConfig serverConfig, Integer ... expectedStatusCodes) {
        return this.executeDownloadRequest(request, serverConfig.getUserName(), this.serverConfigService.decrypt(serverConfig.getPassword()), expectedStatusCodes);
    }

    public AttachmentResponseInfo executeDownloadRequest(HttpUriRequest request, String userName, String password) {
        return this.executeDownloadRequest(request, userName, password, 200);
    }

    /*
     * Exception decompiling
     */
    public AttachmentResponseInfo executeDownloadRequest(HttpUriRequest request, String userName, String password, Integer ... expectedStatusCodes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ResponseInfo execute(HttpUriRequest request, ServerConfig serverConfig) {
        return this.execute(request, serverConfig, 200);
    }

    public ResponseInfo execute(HttpUriRequest request, ServerConfig serverConfig, int ... expectedStatusCodes) {
        return this.execute(request, serverConfig.getUserName(), this.serverConfigService.decrypt(serverConfig.getPassword()), expectedStatusCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseInfo execute(HttpUriRequest request, String userName, String password, int ... expectedStatusCodes) {
        Throwable throwable;
        CloseableHttpResponse response;
        FlowableServiceException exception;
        block32: {
            ResponseInfo responseInfo;
            CloseableHttpClient client;
            block33: {
                block34: {
                    boolean success;
                    exception = null;
                    client = this.getHttpClient(userName, password);
                    response = client.execute(request);
                    throwable = null;
                    JsonNode bodyNode = this.readJsonContent(response.getEntity().getContent());
                    int statusCode = -1;
                    if (response.getStatusLine() != null) {
                        statusCode = response.getStatusLine().getStatusCode();
                    }
                    if (!(success = Arrays.asList(new int[][]{expectedStatusCodes}).contains(statusCode))) break block32;
                    responseInfo = new ResponseInfo(statusCode, bodyNode);
                    if (response == null) break block33;
                    if (throwable == null) break block34;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block33;
                }
                response.close();
            }
            try {
                client.close();
                return responseInfo;
            }
            catch (Exception e) {
                LOGGER.warn("Error closing http client instance", (Throwable)e);
            }
            return responseInfo;
        }
        try {
            try {
                exception = new FlowableServiceException(this.extractError(this.readJsonContent(response.getEntity().getContent()), "An error occurred while calling Flowable: " + response.getStatusLine()));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error consuming response from uri {}", (Object)request.getURI(), (Object)e);
            exception = this.wrapException(e, request);
        }
        if (exception == null) return null;
        throw exception;
    }

    public void execute(HttpUriRequest request, HttpServletResponse httpResponse, ServerConfig serverConfig) {
        this.execute(request, httpResponse, serverConfig.getUserName(), this.serverConfigService.decrypt(serverConfig.getPassword()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpUriRequest request, HttpServletResponse httpResponse, String userName, String password) {
        FlowableServiceException exception = null;
        CloseableHttpClient client = this.getHttpClient(userName, password);
        try {
            try (CloseableHttpResponse response = client.execute(request);){
                if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() != 401) {
                    httpResponse.setStatus(response.getStatusLine().getStatusCode());
                    if (response.getEntity() != null && response.getEntity().getContentType() != null) {
                        httpResponse.setContentType(response.getEntity().getContentType().getValue());
                        response.getEntity().writeTo((OutputStream)httpResponse.getOutputStream());
                    }
                } else {
                    exception = new FlowableServiceException(this.extractError(this.readJsonContent(response.getEntity().getContent()), "An error occurred while calling Flowable: " + response.getStatusLine()));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error consuming response from uri {}", (Object)request.getURI(), (Object)e);
                exception = this.wrapException(e, request);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing request to uri {}", (Object)request.getURI(), (Object)e);
            exception = this.wrapException(e, request);
        }
        finally {
            try {
                client.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error closing http client instance", (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeRequestAsString(HttpUriRequest request, ServerConfig serverConfig, int expectedStatusCode) {
        String result;
        FlowableServiceException exception;
        block20: {
            exception = null;
            result = null;
            CloseableHttpClient client = this.getHttpClient(serverConfig);
            try {
                boolean success;
                CloseableHttpResponse response = client.execute(request);
                boolean bl = success = response.getStatusLine() != null && response.getStatusLine().getStatusCode() == expectedStatusCode;
                if (success) {
                    result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"utf-8");
                    break block20;
                }
                String errorMessage = null;
                try {
                    if (response.getEntity().getContentLength() != 0L) {
                        InputStream responseContent = response.getEntity().getContent();
                        JsonNode errorBody = this.objectMapper.readTree(responseContent);
                        errorMessage = this.extractError(errorBody, "An error occurred while calling Flowable: " + response.getStatusLine());
                    } else {
                        errorMessage = "An error was returned when calling the Flowable server";
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error consuming response from uri {}", (Object)request.getURI(), (Object)e);
                    exception = this.wrapException(e, request);
                }
                finally {
                    response.close();
                }
                exception = new FlowableServiceException(errorMessage);
            }
            catch (Exception e) {
                LOGGER.error("Error executing request to uri {}", (Object)request.getURI(), (Object)e);
                exception = this.wrapException(e, request);
            }
            finally {
                try {
                    client.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error closing http client instance", (Throwable)e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    public FlowableServiceException wrapException(Exception e, HttpUriRequest request) {
        if (e instanceof HttpHostConnectException) {
            return new FlowableServiceException("Unable to connect to the Flowable server.");
        }
        if (e instanceof ConnectTimeoutException) {
            return new FlowableServiceException("Connection to the Flowable server timed out.");
        }
        return new FlowableServiceException(e.getClass().getName() + ": " + e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRequestNoResponseBody(HttpUriRequest request, ServerConfig serverConfig, int expectedStatusCode) {
        FlowableServiceException exception;
        block19: {
            exception = null;
            CloseableHttpClient client = this.getHttpClient(serverConfig);
            try {
                boolean success;
                CloseableHttpResponse response = client.execute(request);
                boolean bl = success = response.getStatusLine() != null && response.getStatusLine().getStatusCode() == expectedStatusCode;
                if (success) break block19;
                String errorMessage = null;
                try {
                    if (response.getEntity() != null && response.getEntity().getContentLength() != 0L) {
                        InputStream responseContent = response.getEntity().getContent();
                        JsonNode errorBody = this.objectMapper.readTree(responseContent);
                        errorMessage = this.extractError(errorBody, "An error occurred while calling Flowable: " + response.getStatusLine());
                    } else {
                        errorMessage = "An error was returned when calling the Flowable server";
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error consuming response from uri {}", (Object)request.getURI(), (Object)e);
                    exception = this.wrapException(e, request);
                }
                finally {
                    response.close();
                }
                exception = new FlowableServiceException(errorMessage);
            }
            catch (Exception e) {
                LOGGER.error("Error executing request to uri {}", (Object)request.getURI(), (Object)e);
                exception = this.wrapException(e, request);
            }
            finally {
                try {
                    client.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error closing http client instance", (Throwable)e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String extractError(JsonNode errorBody, String defaultValue) {
        if (errorBody != null && errorBody.isObject() && errorBody.has("exception")) {
            return errorBody.get("exception").asText();
        }
        return defaultValue;
    }

    public HttpPost createPost(String uri, ServerConfig serverConfig) {
        HttpPost post = new HttpPost(this.getServerUrl(serverConfig, uri));
        post.setHeader("Content-Type", "application/json");
        post.setHeader("Accept", "application/json");
        return post;
    }

    public HttpPost createPost(URIBuilder builder, ServerConfig serverConfig) {
        HttpPost post = new HttpPost(this.getServerUrl(serverConfig, builder));
        post.setHeader("Content-Type", "application/json");
        post.setHeader("Accept", "application/json");
        return post;
    }

    public HttpPut createPut(String uri, ServerConfig serverConfig) {
        HttpPut put = new HttpPut(this.getServerUrl(serverConfig, uri));
        put.setHeader("Content-Type", "application/json");
        put.setHeader("Accept", "application/json");
        return put;
    }

    public HttpPut createPut(URIBuilder builder, ServerConfig serverConfig) {
        HttpPut put = new HttpPut(this.getServerUrl(serverConfig, builder));
        put.setHeader("Content-Type", "application/json");
        put.setHeader("Accept", "application/json");
        return put;
    }

    public HttpDelete createDelete(URIBuilder builder, ServerConfig serverConfig) {
        HttpDelete delete = new HttpDelete(this.getServerUrl(serverConfig, builder));
        delete.setHeader("Content-Type", "application/json");
        delete.setHeader("Accept", "application/json");
        return delete;
    }

    public StringEntity createStringEntity(JsonNode json) {
        try {
            return new StringEntity(json.toString());
        }
        catch (Exception e) {
            LOGGER.warn("Error translation json to http client entity {}", (Object)json, (Object)e);
            return null;
        }
    }

    public StringEntity createStringEntity(String json) {
        try {
            return new StringEntity(json);
        }
        catch (Exception e) {
            LOGGER.warn("Error translation json to http client entity {}", (Object)json, (Object)e);
            return null;
        }
    }

    public String getServerUrl(ServerConfig serverConfig, String uri) {
        return this.getServerUrl(serverConfig.getContextRoot(), serverConfig.getRestRoot(), serverConfig.getServerAddress(), serverConfig.getPort(), uri);
    }

    public String getServerUrl(String contextRoot, String restRoot, String serverAddress, Integer port, String uri) {
        String actualContextRoot = null;
        actualContextRoot = contextRoot != null ? this.stripSlashes(contextRoot) : DEFAULT_FLOWABLE_CONTEXT_ROOT;
        String actualRestRoot = null;
        actualRestRoot = restRoot != null ? this.stripSlashes(restRoot) : DEFAULT_FLOWABLE_REST_ROOT;
        String finalUrl = serverAddress + ":" + port;
        if (StringUtils.isNotEmpty((CharSequence)actualContextRoot)) {
            finalUrl = finalUrl + "/" + actualContextRoot;
        }
        if (StringUtils.isNotEmpty((CharSequence)actualRestRoot)) {
            finalUrl = finalUrl + "/" + actualRestRoot;
        }
        if (StringUtils.isNotEmpty((CharSequence)uri) && !uri.startsWith("/")) {
            uri = "/" + uri;
        }
        URIBuilder builder = this.createUriBuilder(finalUrl + uri);
        return builder.toString();
    }

    public String getAppServerUrl(ServerConfig serverConfig, String uri) {
        String contextRoot = null;
        contextRoot = StringUtils.isNotEmpty((CharSequence)serverConfig.getContextRoot()) ? this.stripSlashes(serverConfig.getContextRoot()) : DEFAULT_FLOWABLE_CONTEXT_ROOT;
        return "http://" + serverConfig.getServerAddress() + ":" + serverConfig.getPort() + "/" + contextRoot + "/" + uri;
    }

    public URIBuilder createUriBuilder(String url) {
        try {
            return new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            throw new FlowableServiceException("Error while creating Flowable endpoint URL: " + e.getMessage());
        }
    }

    public String getServerUrl(ServerConfig serverConfig, URIBuilder builder) {
        try {
            return this.getServerUrl(serverConfig, builder.build().toString());
        }
        catch (URISyntaxException e) {
            throw new FlowableServiceException("Error while creating Flowable endpoint URL: " + e.getMessage());
        }
    }

    public String getUriWithPagingAndOrderParameters(URIBuilder builder, JsonNode bodyNode) throws URISyntaxException {
        this.addParameterToBuilder("size", bodyNode, builder);
        this.addParameterToBuilder("sort", bodyNode, builder);
        this.addParameterToBuilder("order", bodyNode, builder);
        return builder.build().toString();
    }

    public void addParameterToBuilder(String name, JsonNode bodyNode, URIBuilder builder) {
        JsonNode nameNode = bodyNode.get(name);
        if (nameNode != null && !nameNode.isNull()) {
            builder.addParameter(name, nameNode.asText());
            ((ObjectNode)bodyNode).remove(name);
        }
    }

    protected String stripSlashes(String url) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    protected JsonNode readJsonContent(InputStream requestContent) {
        try {
            return this.objectMapper.readTree(IOUtils.toString((InputStream)requestContent, (String)"utf-8"));
        }
        catch (Exception e) {
            LOGGER.debug("Error parsing error message", (Throwable)e);
            return null;
        }
    }
}

