/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.JobService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessInstanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceService.class);
    public static final String HISTORIC_PROCESS_INSTANCE_URL = "history/historic-process-instances/{0}";
    public static final String HISTORIC_TASK_LIST_URL = "history/historic-task-instances";
    public static final String HISTORIC_VARIABLE_INSTANCE_LIST_URL = "history/historic-variable-instances";
    public static final String HISTORIC_ACTIVITY_INSTANCE_LIST_URL = "history/historic-activity-instances";
    public static final String HISTORIC_DECISION_EXECUTION_LIST_URL = "dmn-history/historic-decision-executions";
    public static final String CURRENT_ACTIVITY_INSTANCE_LIST_URL = "runtime/executions/{0}/activities";
    public static final String RUNTIME_PROCESS_INSTANCE_URL = "runtime/process-instances/{0}";
    public static final String RUNTIME_PROCESS_INSTANCE_VARIABLES = "runtime/process-instances/{0}/variables";
    public static final String RUNTIME_PROCESS_INSTANCE_VARIABLE_URL = "runtime/process-instances/{0}/variables/{1}";
    public static final String RUNTIME_PROCESS_INSTANCE_CHANGE_STATE_URL = "runtime/process-instances/{0}/change-state";
    private static final String DEFAULT_SUBTASK_RESULT_SIZE = "1024";
    private static final String DEFAULT_ACTIVITY_SIZE = "1024";
    private static final String DEFAULT_PROCESSINSTANCE_SIZE = "100";
    private static final String DEFAULT_VARIABLE_RESULT_SIZE = "1024";
    @Autowired
    protected FlowableClientService clientUtil;
    @Autowired
    protected JobService jobService;
    @Autowired
    protected ObjectMapper objectMapper;

    public JsonNode listProcesInstances(ObjectNode bodyNode, ServerConfig serverConfig) {
        JsonNode resultNode = null;
        try {
            URIBuilder builder = new URIBuilder("query/historic-process-instances");
            String uri = this.clientUtil.getUriWithPagingAndOrderParameters(builder, (JsonNode)bodyNode);
            HttpPost post = this.clientUtil.createPost(uri, serverConfig);
            post.setEntity((HttpEntity)this.clientUtil.createStringEntity(bodyNode.toString()));
            resultNode = this.clientUtil.executeRequest((HttpUriRequest)post, serverConfig);
        }
        catch (Exception e) {
            throw new FlowableServiceException(e.getMessage(), e);
        }
        return resultNode;
    }

    public JsonNode listProcesInstancesForProcessDefinition(ObjectNode bodyNode, ServerConfig serverConfig) {
        JsonNode resultNode = null;
        try {
            URIBuilder builder = new URIBuilder("query/historic-process-instances");
            builder.addParameter("size", DEFAULT_PROCESSINSTANCE_SIZE);
            builder.addParameter("sort", "startTime");
            builder.addParameter("order", "desc");
            String uri = this.clientUtil.getUriWithPagingAndOrderParameters(builder, (JsonNode)bodyNode);
            HttpPost post = this.clientUtil.createPost(uri, serverConfig);
            post.setEntity((HttpEntity)this.clientUtil.createStringEntity(bodyNode.toString()));
            resultNode = this.clientUtil.executeRequest((HttpUriRequest)post, serverConfig);
        }
        catch (Exception e) {
            throw new FlowableServiceException(e.getMessage(), e);
        }
        return resultNode;
    }

    public JsonNode getProcessInstance(ServerConfig serverConfig, String processInstanceId) {
        if (processInstanceId == null) {
            throw new IllegalArgumentException("Process instance id is required");
        }
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(HISTORIC_PROCESS_INSTANCE_URL, processInstanceId));
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getTasks(ServerConfig serverConfig, String processInstanceId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(HISTORIC_TASK_LIST_URL);
        builder.addParameter("processInstanceId", processInstanceId);
        builder.addParameter("size", "1024");
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getDecisionExecutions(ServerConfig serverConfig, String processInstanceId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(HISTORIC_DECISION_EXECUTION_LIST_URL);
        builder.addParameter("instanceId", processInstanceId);
        builder.addParameter("size", "1024");
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getVariables(ServerConfig serverConfig, String processInstanceId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(HISTORIC_VARIABLE_INSTANCE_LIST_URL);
        builder.addParameter("processInstanceId", processInstanceId);
        builder.addParameter("size", "1024");
        builder.addParameter("sort", "variableName");
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public void updateVariable(ServerConfig serverConfig, String processInstanceId, String variableName, ObjectNode objectNode) {
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(RUNTIME_PROCESS_INSTANCE_VARIABLE_URL, processInstanceId, variableName));
        HttpPut put = this.clientUtil.createPut(builder, serverConfig);
        put.setEntity((HttpEntity)this.clientUtil.createStringEntity(objectNode.toString()));
        this.clientUtil.executeRequest((HttpUriRequest)put, serverConfig);
    }

    public void createVariable(ServerConfig serverConfig, String processInstanceId, ObjectNode objectNode) {
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(RUNTIME_PROCESS_INSTANCE_VARIABLES, processInstanceId));
        HttpPost post = this.clientUtil.createPost(builder, serverConfig);
        ArrayNode variablesNode = this.objectMapper.createArrayNode();
        variablesNode.add((JsonNode)objectNode);
        post.setEntity((HttpEntity)this.clientUtil.createStringEntity(variablesNode.toString()));
        this.clientUtil.executeRequest((HttpUriRequest)post, serverConfig, 201);
    }

    public void deleteVariable(ServerConfig serverConfig, String processInstanceId, String variableName) {
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(RUNTIME_PROCESS_INSTANCE_VARIABLE_URL, processInstanceId, variableName));
        HttpDelete delete = this.clientUtil.createDelete(builder, serverConfig);
        this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)delete, serverConfig, 204);
    }

    public void executeAction(ServerConfig serverConfig, String processInstanceId, JsonNode actionBody) throws FlowableServiceException {
        boolean validAction = false;
        if (actionBody.has("action")) {
            String action = actionBody.get("action").asText();
            if ("delete".equals(action)) {
                validAction = true;
                URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(HISTORIC_PROCESS_INSTANCE_URL, processInstanceId));
                HttpDelete delete = new HttpDelete(this.clientUtil.getServerUrl(serverConfig, builder));
                this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)delete, serverConfig, 204);
            } else if ("terminate".equals(action)) {
                validAction = true;
                URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(RUNTIME_PROCESS_INSTANCE_URL, processInstanceId));
                if (actionBody.has("deleteReason")) {
                    builder.addParameter("deleteReason", actionBody.get("deleteReason").asText());
                }
                HttpDelete delete = new HttpDelete(this.clientUtil.getServerUrl(serverConfig, builder));
                this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)delete, serverConfig, 204);
            }
        }
        if (!validAction) {
            throw new BadRequestException("Action is missing in the request body or the given action is not supported.");
        }
    }

    public void changeActivityState(ServerConfig serverConfig, String processInstanceId, JsonNode changeActivityBody) throws FlowableServiceException {
        try {
            URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(RUNTIME_PROCESS_INSTANCE_CHANGE_STATE_URL, processInstanceId));
            HttpPost post = this.clientUtil.createPost(builder.build().toString(), serverConfig);
            post.setEntity((HttpEntity)this.clientUtil.createStringEntity(changeActivityBody.toString()));
            this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)post, serverConfig, 200);
        }
        catch (Exception e) {
            throw new FlowableServiceException(e.getMessage(), e);
        }
    }

    public JsonNode getSubProcesses(ServerConfig serverConfig, String processInstanceId) {
        ObjectNode requestNode = this.objectMapper.createObjectNode();
        requestNode.put("superProcessInstanceId", processInstanceId);
        return this.listProcesInstances(requestNode, serverConfig);
    }

    public JsonNode getJobs(ServerConfig serverConfig, String processInstanceId) {
        return this.jobService.listJobs(serverConfig, Collections.singletonMap("processInstanceId", new String[]{processInstanceId}));
    }

    public List<String> getCompletedActivityInstancesAndProcessDefinitionId(ServerConfig serverConfig, String processInstanceId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(HISTORIC_ACTIVITY_INSTANCE_LIST_URL);
        builder.addParameter("processInstanceId", processInstanceId);
        builder.addParameter("sort", "startTime");
        builder.addParameter("order", "asc");
        builder.addParameter("size", "1024");
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        JsonNode node = this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
        ArrayList<String> result = new ArrayList<String>();
        if (node.has("data") && node.get("data").isArray()) {
            ArrayNode data = (ArrayNode)node.get("data");
            ObjectNode activity = null;
            for (int i = 0; i < data.size(); ++i) {
                activity = (ObjectNode)data.get(i);
                if (!activity.has("activityType")) continue;
                result.add(activity.get("activityId").asText());
            }
        }
        return result;
    }

    public List<String> getCurrentActivityInstances(ServerConfig serverConfig, String processInstanceId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(CURRENT_ACTIVITY_INSTANCE_LIST_URL, processInstanceId));
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        JsonNode node = this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
        ArrayList<String> result = new ArrayList<String>();
        if (node.isArray()) {
            ArrayNode data = (ArrayNode)node;
            for (int i = 0; i < data.size(); ++i) {
                if (data.get(i) == null) continue;
                result.add(data.get(i).asText());
            }
        }
        return result;
    }
}

