/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.AttachmentResponseInfo;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppService {
    public static final String APP_LIST_URL = "enterprise/runtime-app-deployments";
    public static final String APP_URL = "enterprise/runtime-app-deployments/{0}";
    public static final String PROCESS_DEFINITIONS_URL = "enterprise/process-definitions";
    public static final String DECISION_TABLES_URL = "enterprise/decisions/decision-tables";
    public static final String FORMS_URL = "enterprise/forms";
    public static final String APP_IMPORT_AND_PUBLISH_URL = "enterprise/app-definitions/publish-app";
    public static final String APP_IMPORT_AND_PUBLISH_AS_NEW_VERSION_URL = "/enterprise/app-definitions/{0}/publish-app";
    public static final String EXPORT_DEPLOYED_APP_URL = "enterprise/export-app-deployment/{0}";
    public static final String EXPORT_APP_URL = "enterprise/app-definitions/{0}/export";
    public static final String APP_BY_DEPLOYMENT_URL = "enterprise/runtime-app-deployment";
    @Autowired
    protected FlowableClientService clientUtil;

    public JsonNode listAppDefinitions(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = this.clientUtil.createUriBuilder(APP_LIST_URL);
        this.addParametersToBuilder(builder, parameterMap);
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getAppDefinition(ServerConfig serverConfig, String appDeploymentId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, this.clientUtil.createUriBuilder(MessageFormat.format(APP_URL, appDeploymentId))));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public void getAppDefinitionByDeployment(ServerConfig serverConfig, HttpServletResponse httpResponse, Map<String, String[]> parameterMap) {
        URIBuilder builder = this.clientUtil.createUriBuilder(APP_BY_DEPLOYMENT_URL);
        this.addParametersToBuilder(builder, parameterMap);
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        this.clientUtil.execute((HttpUriRequest)get, httpResponse, serverConfig);
    }

    public void deleteAppDeployment(ServerConfig serverConfig, HttpServletResponse httpResponse, String appDeploymentId) {
        HttpDelete delete = new HttpDelete(this.clientUtil.getServerUrl(serverConfig, this.clientUtil.createUriBuilder(MessageFormat.format(APP_URL, appDeploymentId))));
        this.clientUtil.execute((HttpUriRequest)delete, httpResponse, serverConfig);
    }

    public JsonNode getProcessDefinitionsForDeploymentId(ServerConfig serverConfig, String deploymentId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(PROCESS_DEFINITIONS_URL);
        builder.addParameter("deploymentId", deploymentId);
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getDecisionDefinitionsForDeploymentId(ServerConfig serverConfig, String dmnDeploymentId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(DECISION_TABLES_URL);
        builder.addParameter("deploymentId", dmnDeploymentId);
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getFormsForAppDeploymentId(ServerConfig serverConfig, String appDeploymentId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(FORMS_URL);
        builder.addParameter("appDeploymentId", appDeploymentId);
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public void uploadAppDefinition(HttpServletResponse httpResponse, ServerConfig serverConfig, String name, InputStream inputStream) throws IOException {
        this.uploadAppDefinition(httpResponse, serverConfig, name, IOUtils.toByteArray((InputStream)inputStream));
    }

    public JsonNode exportApp(ServerConfig serverConfig, String deploymentId, HttpServletResponse httpResponse) throws IOException {
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(EXPORT_DEPLOYED_APP_URL, deploymentId));
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeDownloadRequest((HttpUriRequest)get, httpResponse, serverConfig);
    }

    public JsonNode redeployApp(HttpServletResponse httpResponse, ServerConfig serverConfig, ServerConfig targetServerConfig, String deploymentId) throws IOException {
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(EXPORT_DEPLOYED_APP_URL, deploymentId));
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        AttachmentResponseInfo attachmentResponseInfo = this.clientUtil.executeDownloadRequest((HttpUriRequest)get, serverConfig, 200, 404);
        if (attachmentResponseInfo.isSuccess()) {
            this.uploadAppDefinition(httpResponse, targetServerConfig, attachmentResponseInfo.getFileName(), attachmentResponseInfo.getBytes());
            return null;
        }
        httpResponse.setStatus(attachmentResponseInfo.getStatusCode());
        return attachmentResponseInfo.getContent();
    }

    public JsonNode redeployReplaceApp(HttpServletResponse httpResponse, ServerConfig serverConfig, ServerConfig targetServerConfig, String deploymentId, String appId) throws IOException {
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(EXPORT_DEPLOYED_APP_URL, deploymentId));
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        AttachmentResponseInfo attachmentResponseInfo = this.clientUtil.executeDownloadRequest((HttpUriRequest)get, serverConfig, 200, 404);
        if (attachmentResponseInfo.isSuccess()) {
            this.uploadNewAppDefinitionVersion(httpResponse, targetServerConfig, attachmentResponseInfo.getFileName(), attachmentResponseInfo.getBytes(), appId);
            return null;
        }
        httpResponse.setStatus(attachmentResponseInfo.getStatusCode());
        return attachmentResponseInfo.getContent();
    }

    protected void uploadAppDefinition(HttpServletResponse httpResponse, ServerConfig serverConfig, String name, byte[] bytes) throws IOException {
        HttpPost post = new HttpPost(this.clientUtil.getServerUrl(serverConfig, APP_IMPORT_AND_PUBLISH_URL));
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("file", bytes, ContentType.APPLICATION_OCTET_STREAM, name).build();
        post.setEntity(reqEntity);
        this.clientUtil.execute((HttpUriRequest)post, httpResponse, serverConfig);
    }

    protected void uploadNewAppDefinitionVersion(HttpServletResponse httpResponse, ServerConfig serverConfig, String name, byte[] bytes, String appId) throws IOException {
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(APP_IMPORT_AND_PUBLISH_AS_NEW_VERSION_URL, appId));
        HttpPost post = new HttpPost(this.clientUtil.getServerUrl(serverConfig, builder));
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("file", bytes, ContentType.APPLICATION_OCTET_STREAM, name).build();
        post.setEntity(reqEntity);
        this.clientUtil.execute((HttpUriRequest)post, httpResponse, serverConfig);
    }

    protected void addParametersToBuilder(URIBuilder builder, Map<String, String[]> parameterMap) {
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
    }
}

