/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.conf;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.flowable.app.service.exception.InternalServerErrorException;
import org.flowable.engine.common.api.FlowableException;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class DatabaseConfiguration {
    private final Logger log = LoggerFactory.getLogger(DatabaseConfiguration.class);
    protected static final String LIQUIBASE_CHANGELOG_PREFIX = "ACT_DE_";
    @Autowired
    protected Environment env;
    @Autowired
    protected ResourceLoader resourceLoader;
    protected static Properties databaseTypeMappings = DatabaseConfiguration.getDefaultDatabaseTypeMappings();
    public static final String DATABASE_TYPE_H2 = "h2";
    public static final String DATABASE_TYPE_HSQL = "hsql";
    public static final String DATABASE_TYPE_MYSQL = "mysql";
    public static final String DATABASE_TYPE_ORACLE = "oracle";
    public static final String DATABASE_TYPE_POSTGRES = "postgres";
    public static final String DATABASE_TYPE_MSSQL = "mssql";
    public static final String DATABASE_TYPE_DB2 = "db2";

    public static Properties getDefaultDatabaseTypeMappings() {
        Properties databaseTypeMappings = new Properties();
        databaseTypeMappings.setProperty("H2", DATABASE_TYPE_H2);
        databaseTypeMappings.setProperty("HSQL Database Engine", DATABASE_TYPE_HSQL);
        databaseTypeMappings.setProperty("MySQL", DATABASE_TYPE_MYSQL);
        databaseTypeMappings.setProperty("Oracle", DATABASE_TYPE_ORACLE);
        databaseTypeMappings.setProperty("PostgreSQL", DATABASE_TYPE_POSTGRES);
        databaseTypeMappings.setProperty("Microsoft SQL Server", DATABASE_TYPE_MSSQL);
        databaseTypeMappings.setProperty(DATABASE_TYPE_DB2, DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/NT", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/NT64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDP", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUX390", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXX8664", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXZ64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXPPC64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/400 SQL", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/6000", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDB iSeries", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/AIX64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/HPUX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/HP64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/SUN", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/SUN64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/PTX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/2", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDB AS400", DATABASE_TYPE_DB2);
        return databaseTypeMappings;
    }

    @Bean
    public DataSource dataSource() {
        Integer maxIdleTimeExcessConnections;
        Integer maxIdleTime;
        Boolean testConnectionOnCheckOut;
        Integer acquireIncrement;
        Integer maxPoolSize;
        this.log.info("Configuring Datasource");
        String dataSourceJndiName = this.env.getProperty("datasource.jndi.name");
        if (StringUtils.isNotEmpty((CharSequence)dataSourceJndiName)) {
            this.log.info("Using jndi datasource '{}'", (Object)dataSourceJndiName);
            JndiDataSourceLookup dsLookup = new JndiDataSourceLookup();
            dsLookup.setResourceRef(((Boolean)this.env.getProperty("datasource.jndi.resourceRef", Boolean.class, (Object)Boolean.TRUE)).booleanValue());
            DataSource dataSource = dsLookup.getDataSource(dataSourceJndiName);
            return dataSource;
        }
        String dataSourceDriver = this.env.getProperty("datasource.driver", "org.h2.Driver");
        String dataSourceUrl = this.env.getProperty("datasource.url", "jdbc:h2:mem:flowable;DB_CLOSE_DELAY=-1");
        String dataSourceUsername = this.env.getProperty("datasource.username", "sa");
        String dataSourcePassword = this.env.getProperty("datasource.password", "");
        Integer minPoolSize = (Integer)this.env.getProperty("datasource.min-pool-size", Integer.class);
        if (minPoolSize == null) {
            minPoolSize = 10;
        }
        if ((maxPoolSize = (Integer)this.env.getProperty("datasource.max-pool-size", Integer.class)) == null) {
            maxPoolSize = 100;
        }
        if ((acquireIncrement = (Integer)this.env.getProperty("datasource.acquire-increment", Integer.class)) == null) {
            acquireIncrement = 5;
        }
        String preferredTestQuery = this.env.getProperty("datasource.preferred-test-query");
        Boolean testConnectionOnCheckin = (Boolean)this.env.getProperty("datasource.test-connection-on-checkin", Boolean.class);
        if (testConnectionOnCheckin == null) {
            testConnectionOnCheckin = true;
        }
        if ((testConnectionOnCheckOut = (Boolean)this.env.getProperty("datasource.test-connection-on-checkout", Boolean.class)) == null) {
            testConnectionOnCheckOut = true;
        }
        if ((maxIdleTime = (Integer)this.env.getProperty("datasource.max-idle-time", Integer.class)) == null) {
            maxIdleTime = 1800;
        }
        if ((maxIdleTimeExcessConnections = (Integer)this.env.getProperty("datasource.max-idle-time-excess-connections", Integer.class)) == null) {
            maxIdleTimeExcessConnections = 1800;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Configuring Datasource with following properties (omitted password for security)");
            this.log.info("datasource driver : {}", (Object)dataSourceDriver);
            this.log.info("datasource url : {}", (Object)dataSourceUrl);
            this.log.info("datasource user name : {}", (Object)dataSourceUsername);
            this.log.info("Min pool size | Max pool size | acquire increment : {} | {} | {}", new Object[]{minPoolSize, maxPoolSize, acquireIncrement});
        }
        ComboPooledDataSource ds = new ComboPooledDataSource();
        try {
            ds.setDriverClass(dataSourceDriver);
        }
        catch (PropertyVetoException e) {
            this.log.error("Could not set Jdbc Driver class", (Throwable)e);
            return null;
        }
        ds.setJdbcUrl(dataSourceUrl);
        ds.setUser(dataSourceUsername);
        ds.setPassword(dataSourcePassword);
        ds.setMinPoolSize(minPoolSize.intValue());
        ds.setMaxPoolSize(maxPoolSize.intValue());
        ds.setAcquireIncrement(acquireIncrement.intValue());
        if (preferredTestQuery != null) {
            ds.setPreferredTestQuery(preferredTestQuery);
        }
        ds.setTestConnectionOnCheckin(testConnectionOnCheckin.booleanValue());
        ds.setTestConnectionOnCheckout(testConnectionOnCheckOut.booleanValue());
        ds.setMaxIdleTimeExcessConnections(maxIdleTimeExcessConnections.intValue());
        ds.setMaxIdleTime(maxIdleTime.intValue());
        return ds;
    }

    @Bean
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource(this.dataSource());
        return dataSourceTransactionManager;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory() {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        DataSource dataSource = this.dataSource();
        sqlSessionFactoryBean.setDataSource(dataSource);
        String databaseType = this.initDatabaseType(dataSource);
        if (databaseType == null) {
            throw new FlowableException("couldn't deduct database type");
        }
        try {
            Properties properties = new Properties();
            properties.put("prefix", this.env.getProperty("datasource.prefix", ""));
            properties.put("blobType", "BLOB");
            properties.put("boolValue", "TRUE");
            properties.load(this.getClass().getClassLoader().getResourceAsStream("org/flowable/db/properties/" + databaseType + ".properties"));
            sqlSessionFactoryBean.setConfigurationProperties(properties);
            sqlSessionFactoryBean.setMapperLocations(ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath:/META-INF/modeler-mybatis-mappings/*.xml"));
            sqlSessionFactoryBean.afterPropertiesSet();
            return sqlSessionFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new FlowableException("Could not create sqlSessionFactory", (Throwable)e);
        }
    }

    @Bean(destroyMethod="clearCache")
    public SqlSessionTemplate SqlSessionTemplate() {
        return new SqlSessionTemplate(this.sqlSessionFactory());
    }

    @Bean
    public Liquibase liquibase() {
        this.log.info("Configuring Liquibase");
        try {
            JdbcConnection connection = new JdbcConnection(this.dataSource().getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogLockTableName());
            Liquibase liquibase = new Liquibase("META-INF/liquibase/flowable-modeler-app-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update("flowable");
            return liquibase;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Error creating liquibase database", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String initDatabaseType(DataSource dataSource) {
        String databaseType = null;
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            this.log.info("database product name: '{}'", (Object)databaseProductName);
            databaseType = databaseTypeMappings.getProperty(databaseProductName);
            if (databaseType == null) {
                throw new FlowableException("couldn't deduct database type from database product name '" + databaseProductName + "'");
            }
            this.log.info("using database type: {}", (Object)databaseType);
        }
        catch (SQLException e) {
            this.log.error("Exception while initializing Database connection", (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Exception while closing the Database connection", (Throwable)e);
            }
        }
        return databaseType;
    }
}

