/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.conf;

import java.util.Collections;
import javax.servlet.Filter;
import org.flowable.app.filter.FlowableCookieFilter;
import org.flowable.app.security.AjaxLogoutSuccessHandler;
import org.flowable.app.security.ClearFlowableCookieLogoutHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration {
    public static final String REST_ENDPOINTS_PREFIX = "/app/rest";

    @Bean
    public FlowableCookieFilter flowableCookieFilter() {
        FlowableCookieFilter filter = new FlowableCookieFilter();
        filter.setRequiredPrivileges(Collections.singletonList("access-modeler"));
        return filter;
    }

    @Configuration
    @Order(value=10)
    public static class FormLoginWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        protected FlowableCookieFilter flowableCookieFilter;
        @Autowired
        protected AjaxLogoutSuccessHandler ajaxLogoutSuccessHandler;

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).addFilterBefore((Filter)this.flowableCookieFilter, UsernamePasswordAuthenticationFilter.class).logout().logoutUrl("/app/logout").logoutSuccessHandler((LogoutSuccessHandler)this.ajaxLogoutSuccessHandler).addLogoutHandler((LogoutHandler)new ClearFlowableCookieLogoutHandler()).and()).csrf().disable()).headers().frameOptions().sameOrigin().addHeaderWriter((HeaderWriter)new XXssProtectionHeaderWriter()).and()).authorizeRequests().antMatchers(new String[]{"/app/rest/**"})).hasAuthority("access-modeler");
        }
    }
}

