/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.AppModelDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.AppDefinitionRepresentation;
import org.flowable.ui.modeler.service.BaseAppDefinitionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.UriUtils;

@Service
@Transactional
public class AppDefinitionExportService
extends BaseAppDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDefinitionExportService.class);
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();

    public void exportAppDefinition(HttpServletResponse response, String modelId) throws IOException {
        if (modelId == null) {
            throw new BadRequestException("No application definition id provided");
        }
        Model appModel = this.modelService.getModel(modelId);
        AppDefinitionRepresentation appRepresentation = this.createAppDefinitionRepresentation(appModel);
        this.createAppDefinitionZip(response, appModel, appRepresentation);
    }

    public void exportDeployableAppDefinition(HttpServletResponse response, String modelId) throws IOException {
        if (modelId == null) {
            throw new BadRequestException("No application definition id provided");
        }
        Model appModel = this.modelService.getModel(modelId);
        AppDefinitionRepresentation appRepresentation = this.createAppDefinitionRepresentation(appModel);
        this.createAppDefinitionBar(response, appModel, appRepresentation);
    }

    protected void createAppDefinitionZip(HttpServletResponse response, Model appModel, AppDefinitionRepresentation appDefinition) {
        try {
            List<AppModelDefinition> cmmnModelDefinitions;
            response.setHeader("Content-Disposition", "attachment; filename=\"" + appDefinition.getName() + ".zip\"; filename*=utf-8''" + UriUtils.encode((String)(appDefinition.getName() + ".zip"), (String)"utf-8"));
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)servletOutputStream);
            this.createZipEntry(zipOutputStream, appModel.getName() + ".json", this.createModelEntryJson(appModel));
            HashMap<String, Model> formMap = new HashMap<String, Model>();
            HashMap<String, Model> decisionTableMap = new HashMap<String, Model>();
            List<AppModelDefinition> modelDefinitions = appDefinition.getDefinition().getModels();
            if (CollectionUtils.isNotEmpty(modelDefinitions)) {
                this.createBpmnZipEntries(modelDefinitions, zipOutputStream, formMap, decisionTableMap);
            }
            if (CollectionUtils.isNotEmpty(cmmnModelDefinitions = appDefinition.getDefinition().getCmmnModels())) {
                this.createCmmnZipEntries(cmmnModelDefinitions, zipOutputStream, formMap, decisionTableMap);
            }
            for (Model formModel : formMap.values()) {
                this.createZipEntries(formModel, "form-models", zipOutputStream);
            }
            for (Model decisionTableModel : decisionTableMap.values()) {
                this.createZipEntries(decisionTableModel, "decision-table-models", zipOutputStream);
                try {
                    JsonNode decisionTableNode = this.objectMapper.readTree(decisionTableModel.getModelEditorJson());
                    DmnDefinition dmnDefinition = this.dmnJsonConverter.convertToDmn(decisionTableNode, decisionTableModel.getId(), decisionTableModel.getVersion(), decisionTableModel.getLastUpdated());
                    byte[] dmnXMLBytes = this.dmnXMLConverter.convertToXML(dmnDefinition);
                    this.createZipEntry(zipOutputStream, "decision-table-models/" + decisionTableModel.getKey() + ".dmn", dmnXMLBytes);
                }
                catch (Exception e) {
                    throw new InternalServerErrorException(String.format("Error converting decision table %s to XML", decisionTableModel.getName()));
                }
            }
            zipOutputStream.close();
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Could not generate app definition zip archive", (Throwable)e);
            throw new InternalServerErrorException("Could not generate app definition zip archive");
        }
    }

    public void createAppDefinitionBar(HttpServletResponse response, Model appModel, AppDefinitionRepresentation appDefinition) {
        try {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + appDefinition.getName() + ".bar\"; filename*=utf-8''" + UriUtils.encode((String)(appDefinition.getName() + ".bar"), (String)"utf-8"));
            byte[] deployZipArtifact = this.createDeployableZipArtifact(appModel, appDefinition.getDefinition());
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/zip");
            servletOutputStream.write(deployZipArtifact);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Could not generate app definition bar archive", (Throwable)e);
            throw new InternalServerErrorException("Could not generate app definition bar archive");
        }
    }

    protected void createBpmnZipEntries(List<AppModelDefinition> modelDefinitions, ZipOutputStream zipOutputStream, Map<String, Model> formMap, Map<String, Model> decisionTableMap) throws Exception {
        for (AppModelDefinition modelDef : modelDefinitions) {
            Model model = this.modelService.getModel(modelDef.getId());
            List<Model> referencedModels = this.modelRepository.findByParentModelId(model.getId());
            for (Model childModel : referencedModels) {
                if (2 == childModel.getModelType()) {
                    formMap.put(childModel.getId(), childModel);
                    continue;
                }
                if (4 != childModel.getModelType()) continue;
                decisionTableMap.put(childModel.getId(), childModel);
            }
            BpmnModel bpmnModel = this.modelService.getBpmnModel(model, formMap, decisionTableMap);
            Map<String, StartEvent> startEventMap = this.processNoneStartEvents(bpmnModel);
            for (Process process : bpmnModel.getProcesses()) {
                this.processUserTasks(process.getFlowElements(), process, startEventMap);
            }
            byte[] modelXML = this.modelService.getBpmnXML(bpmnModel);
            this.createZipEntry(zipOutputStream, "bpmn-models/" + model.getKey().replaceAll(" ", "") + ".bpmn", modelXML);
            this.createZipEntries(model, "bpmn-models", zipOutputStream);
        }
    }

    protected void createCmmnZipEntries(List<AppModelDefinition> modelDefinitions, ZipOutputStream zipOutputStream, Map<String, Model> formMap, Map<String, Model> decisionTableMap) throws Exception {
        for (AppModelDefinition modelDef : modelDefinitions) {
            Model model = this.modelService.getModel(modelDef.getId());
            List<Model> referencedModels = this.modelRepository.findByParentModelId(model.getId());
            for (Model childModel : referencedModels) {
                if (2 == childModel.getModelType()) {
                    formMap.put(childModel.getId(), childModel);
                    continue;
                }
                if (4 != childModel.getModelType()) continue;
                decisionTableMap.put(childModel.getId(), childModel);
            }
            CmmnModel cmmnModel = this.modelService.getCmmnModel(model, formMap, decisionTableMap, null, null);
            byte[] modelXML = this.modelService.getCmmnXML(cmmnModel);
            this.createZipEntry(zipOutputStream, "cmmn-models/" + model.getKey().replaceAll(" ", "") + ".cmmn", modelXML);
            this.createZipEntries(model, "cmmn-models", zipOutputStream);
        }
    }

    protected void createZipEntries(Model model, String directoryName, ZipOutputStream zipOutputStream) throws Exception {
        this.createZipEntry(zipOutputStream, directoryName + "/" + model.getKey() + ".json", this.createModelEntryJson(model));
        if (model.getThumbnail() != null) {
            this.createZipEntry(zipOutputStream, directoryName + "/" + model.getKey() + ".png", model.getThumbnail());
        }
    }

    protected String createModelEntryJson(Model model) {
        ObjectNode modelJson = this.objectMapper.createObjectNode();
        modelJson.put("id", model.getId());
        modelJson.put("name", model.getName());
        modelJson.put("key", model.getKey());
        modelJson.put("description", model.getDescription());
        try {
            modelJson.set("editorJson", this.objectMapper.readTree(model.getModelEditorJson()));
        }
        catch (Exception e) {
            LOGGER.error("Error exporting model json for id {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Error exporting model json for id " + model.getId());
        }
        return modelJson.toString();
    }

    protected AppDefinitionRepresentation createAppDefinitionRepresentation(AbstractModel model) {
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing app {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        AppDefinitionRepresentation result = new AppDefinitionRepresentation(model);
        result.setDefinition(appDefinition);
        return result;
    }

    protected void createZipEntry(ZipOutputStream zipOutputStream, String filename, String content) throws Exception {
        this.createZipEntry(zipOutputStream, filename, content.getBytes(Charset.forName("UTF-8")));
    }

    protected void createZipEntry(ZipOutputStream zipOutputStream, String filename, byte[] content) throws Exception {
        ZipEntry entry = new ZipEntry(filename);
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(content);
        zipOutputStream.closeEntry();
    }
}

