/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.flowable.editor.dmn.converter.DmnJsonConverterUtil;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.Model;

public class DecisionTableModelConversionUtil {
    public static Model convertModel(Model decisionTableModel) {
        if (StringUtils.isNotEmpty((CharSequence)decisionTableModel.getModelEditorJson())) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode decisionTableNode = objectMapper.readTree(decisionTableModel.getModelEditorJson());
                DmnJsonConverterUtil.migrateModel((JsonNode)decisionTableNode, (ObjectMapper)objectMapper);
                decisionTableModel.setModelEditorJson(decisionTableNode.toString());
            }
            catch (Exception e) {
                throw new InternalServerErrorException(String.format("Error converting decision table %s to new model version", decisionTableModel.getName()));
            }
        }
        return decisionTableModel;
    }
}

