/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.DataObject;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.Lane;
import org.flowable.bpmn.model.Pool;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Stage;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.util.ImageGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ModelImageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelImageService.class);
    private static float THUMBNAIL_WIDTH = 300.0f;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
    protected CmmnJsonConverter cmmnJsonConverter = new CmmnJsonConverter();

    public byte[] generateThumbnailImage(Model model, ObjectNode editorJsonNode) {
        try {
            BufferedImage modelImage;
            BpmnModel bpmnModel = this.bpmnJsonConverter.convertToBpmnModel((JsonNode)editorJsonNode);
            double scaleFactor = 1.0;
            GraphicInfo diagramInfo = this.calculateDiagramSize(bpmnModel);
            if (diagramInfo.getWidth() > (double)THUMBNAIL_WIDTH) {
                scaleFactor = diagramInfo.getWidth() / (double)THUMBNAIL_WIDTH;
                this.scaleDiagram(bpmnModel, scaleFactor);
            }
            if ((modelImage = ImageGenerator.createImage(bpmnModel, scaleFactor)) != null) {
                return ImageGenerator.createByteArrayForImage(modelImage, "png");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating thumbnail image {}", (Object)model.getId(), (Object)e);
        }
        return null;
    }

    public byte[] generateCmmnThumbnailImage(Model model, ObjectNode editorJsonNode) {
        try {
            BufferedImage modelImage;
            CmmnModel cmmnModel = this.cmmnJsonConverter.convertToCmmnModel((JsonNode)editorJsonNode);
            double scaleFactor = 1.0;
            GraphicInfo diagramInfo = this.calculateDiagramSize(cmmnModel);
            if (diagramInfo.getWidth() > (double)THUMBNAIL_WIDTH) {
                scaleFactor = diagramInfo.getWidth() / (double)THUMBNAIL_WIDTH;
                this.scaleDiagram(cmmnModel, scaleFactor);
            }
            if ((modelImage = ImageGenerator.createCmmnImage(cmmnModel, scaleFactor)) != null) {
                return ImageGenerator.createByteArrayForImage(modelImage, "png");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating thumbnail cmmn image {}", (Object)model.getId(), (Object)e);
        }
        return null;
    }

    protected GraphicInfo calculateDiagramSize(BpmnModel bpmnModel) {
        GraphicInfo diagramInfo = new GraphicInfo();
        for (Pool pool : bpmnModel.getPools()) {
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(pool.getId());
            double elementMaxX = graphicInfo.getX() + graphicInfo.getWidth();
            double elementMaxY = graphicInfo.getY() + graphicInfo.getHeight();
            if (elementMaxX > diagramInfo.getWidth()) {
                diagramInfo.setWidth(elementMaxX);
            }
            if (!(elementMaxY > diagramInfo.getHeight())) continue;
            diagramInfo.setHeight(elementMaxY);
        }
        for (Process process : bpmnModel.getProcesses()) {
            this.calculateWidthForFlowElements(process.getFlowElements(), bpmnModel, diagramInfo);
            this.calculateWidthForArtifacts(process.getArtifacts(), bpmnModel, diagramInfo);
        }
        return diagramInfo;
    }

    protected GraphicInfo calculateDiagramSize(CmmnModel cmmnModel) {
        GraphicInfo diagramInfo = new GraphicInfo();
        for (Case caseModel : cmmnModel.getCases()) {
            Stage stage = caseModel.getPlanModel();
            org.flowable.cmmn.model.GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(stage.getId());
            double elementMaxX = graphicInfo.getX() + graphicInfo.getWidth();
            double elementMaxY = graphicInfo.getY() + graphicInfo.getHeight();
            if (elementMaxX > diagramInfo.getWidth()) {
                diagramInfo.setWidth(elementMaxX);
            }
            if (!(elementMaxY > diagramInfo.getHeight())) continue;
            diagramInfo.setHeight(elementMaxY);
        }
        return diagramInfo;
    }

    protected void scaleDiagram(BpmnModel bpmnModel, double scaleFactor) {
        for (Pool pool : bpmnModel.getPools()) {
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(pool.getId());
            this.scaleGraphicInfo(graphicInfo, scaleFactor);
        }
        for (Process process : bpmnModel.getProcesses()) {
            this.scaleFlowElements(process.getFlowElements(), bpmnModel, scaleFactor);
            this.scaleArtifacts(process.getArtifacts(), bpmnModel, scaleFactor);
            for (Lane lane : process.getLanes()) {
                this.scaleGraphicInfo(bpmnModel.getGraphicInfo(lane.getId()), scaleFactor);
            }
        }
    }

    protected void scaleDiagram(CmmnModel cmmnModel, double scaleFactor) {
        for (Case caseModel : cmmnModel.getCases()) {
            org.flowable.cmmn.model.GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(caseModel.getPlanModel().getId());
            this.scaleCmmnGraphicInfo(graphicInfo, scaleFactor);
            for (Criterion criterion : caseModel.getPlanModel().getExitCriteria()) {
                org.flowable.cmmn.model.GraphicInfo criterionGraphicInfo = cmmnModel.getGraphicInfo(criterion.getId());
                this.scaleCmmnGraphicInfo(criterionGraphicInfo, scaleFactor);
            }
            this.scalePlanItems(caseModel.getPlanModel().getPlanItems(), cmmnModel, scaleFactor);
        }
        this.scaleAssociations(cmmnModel.getAssociations(), cmmnModel, scaleFactor);
    }

    protected void calculateWidthForFlowElements(Collection<FlowElement> elementList, BpmnModel bpmnModel, GraphicInfo diagramInfo) {
        for (FlowElement flowElement : elementList) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            if (flowElement instanceof SequenceFlow) {
                List flowGraphics = bpmnModel.getFlowLocationGraphicInfo(flowElement.getId());
                if (flowGraphics != null && flowGraphics.size() > 0) {
                    graphicInfoList.addAll(flowGraphics);
                }
            } else {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowElement.getId());
                if (graphicInfo != null) {
                    graphicInfoList.add(graphicInfo);
                }
            }
            this.processGraphicInfoList(graphicInfoList, diagramInfo);
        }
    }

    protected void calculateWidthForArtifacts(Collection<Artifact> artifactList, BpmnModel bpmnModel, GraphicInfo diagramInfo) {
        for (Artifact artifact : artifactList) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            if (artifact instanceof org.flowable.bpmn.model.Association) {
                graphicInfoList.addAll(bpmnModel.getFlowLocationGraphicInfo(artifact.getId()));
            } else {
                graphicInfoList.add(bpmnModel.getGraphicInfo(artifact.getId()));
            }
            this.processGraphicInfoList(graphicInfoList, diagramInfo);
        }
    }

    protected void processGraphicInfoList(List<GraphicInfo> graphicInfoList, GraphicInfo diagramInfo) {
        for (GraphicInfo graphicInfo : graphicInfoList) {
            double elementMaxX = graphicInfo.getX() + graphicInfo.getWidth();
            double elementMaxY = graphicInfo.getY() + graphicInfo.getHeight();
            if (elementMaxX > diagramInfo.getWidth()) {
                diagramInfo.setWidth(elementMaxX);
            }
            if (!(elementMaxY > diagramInfo.getHeight())) continue;
            diagramInfo.setHeight(elementMaxY);
        }
    }

    protected void scaleFlowElements(Collection<FlowElement> elementList, BpmnModel bpmnModel, double scaleFactor) {
        for (FlowElement flowElement : elementList) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            if (flowElement instanceof SequenceFlow) {
                List flowList = bpmnModel.getFlowLocationGraphicInfo(flowElement.getId());
                if (flowList != null) {
                    graphicInfoList.addAll(flowList);
                }
            } else if (!DataObject.class.isInstance(flowElement)) {
                graphicInfoList.add(bpmnModel.getGraphicInfo(flowElement.getId()));
            }
            this.scaleGraphicInfoList(graphicInfoList, scaleFactor);
            if (!(flowElement instanceof SubProcess)) continue;
            SubProcess subProcess = (SubProcess)flowElement;
            this.scaleFlowElements(subProcess.getFlowElements(), bpmnModel, scaleFactor);
        }
    }

    protected void scaleArtifacts(Collection<Artifact> artifactList, BpmnModel bpmnModel, double scaleFactor) {
        for (Artifact artifact : artifactList) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            if (artifact instanceof org.flowable.bpmn.model.Association) {
                List flowList = bpmnModel.getFlowLocationGraphicInfo(artifact.getId());
                if (flowList != null) {
                    graphicInfoList.addAll(flowList);
                }
            } else {
                graphicInfoList.add(bpmnModel.getGraphicInfo(artifact.getId()));
            }
            this.scaleGraphicInfoList(graphicInfoList, scaleFactor);
        }
    }

    protected void scalePlanItems(Collection<PlanItem> itemList, CmmnModel cmmnModel, double scaleFactor) {
        for (PlanItem planItem : itemList) {
            org.flowable.cmmn.model.GraphicInfo criterionGraphicInfo;
            org.flowable.cmmn.model.GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(planItem.getId());
            this.scaleCmmnGraphicInfo(graphicInfo, scaleFactor);
            if (planItem.getPlanItemDefinition() instanceof Stage) {
                Stage stage = (Stage)planItem.getPlanItemDefinition();
                this.scalePlanItems(stage.getPlanItems(), cmmnModel, scaleFactor);
            }
            for (Criterion criterion : planItem.getEntryCriteria()) {
                criterionGraphicInfo = cmmnModel.getGraphicInfo(criterion.getId());
                this.scaleCmmnGraphicInfo(criterionGraphicInfo, scaleFactor);
            }
            for (Criterion criterion : planItem.getExitCriteria()) {
                criterionGraphicInfo = cmmnModel.getGraphicInfo(criterion.getId());
                this.scaleCmmnGraphicInfo(criterionGraphicInfo, scaleFactor);
            }
        }
    }

    protected void scaleAssociations(List<Association> associationList, CmmnModel cmmnModel, double scaleFactor) {
        for (Association association : associationList) {
            List flowList = cmmnModel.getFlowLocationGraphicInfo(association.getId());
            this.scaleCmmnGraphicInfoList(flowList, scaleFactor);
        }
    }

    protected void scaleGraphicInfoList(List<GraphicInfo> graphicInfoList, double scaleFactor) {
        for (GraphicInfo graphicInfo : graphicInfoList) {
            this.scaleGraphicInfo(graphicInfo, scaleFactor);
        }
    }

    protected void scaleGraphicInfo(GraphicInfo graphicInfo, double scaleFactor) {
        graphicInfo.setX(graphicInfo.getX() / scaleFactor);
        graphicInfo.setY(graphicInfo.getY() / scaleFactor);
        graphicInfo.setWidth(graphicInfo.getWidth() / scaleFactor);
        graphicInfo.setHeight(graphicInfo.getHeight() / scaleFactor);
    }

    protected void scaleCmmnGraphicInfoList(List<org.flowable.cmmn.model.GraphicInfo> graphicInfoList, double scaleFactor) {
        if (graphicInfoList != null) {
            for (org.flowable.cmmn.model.GraphicInfo graphicInfo : graphicInfoList) {
                this.scaleCmmnGraphicInfo(graphicInfo, scaleFactor);
            }
        }
    }

    protected void scaleCmmnGraphicInfo(org.flowable.cmmn.model.GraphicInfo graphicInfo, double scaleFactor) {
        graphicInfo.setX(graphicInfo.getX() / scaleFactor);
        graphicInfo.setY(graphicInfo.getY() / scaleFactor);
        graphicInfo.setWidth(graphicInfo.getWidth() / scaleFactor);
        graphicInfo.setHeight(graphicInfo.getHeight() / scaleFactor);
    }
}

