/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service.mapper;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FormProperty;
import org.flowable.bpmn.model.UserTask;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.modeler.service.mapper.AbstractInfoMapper;

public class UserTaskInfoMapper
extends AbstractInfoMapper {
    @Override
    protected void mapProperties(Object element) {
        UserTask userTask = (UserTask)element;
        this.createPropertyNode("Assignee", userTask.getAssignee());
        this.createPropertyNode("Candidate users", userTask.getCandidateUsers());
        this.createPropertyNode("Candidate groups", userTask.getCandidateGroups());
        this.createPropertyNode("Due date", userTask.getDueDate());
        this.createPropertyNode("Form key", userTask.getFormKey());
        this.createPropertyNode("Priority", userTask.getPriority());
        if (CollectionUtils.isNotEmpty((Collection)userTask.getFormProperties())) {
            ArrayList<String> formPropertyValues = new ArrayList<String>();
            for (FormProperty formProperty : userTask.getFormProperties()) {
                StringBuilder propertyBuilder = new StringBuilder();
                if (StringUtils.isNotEmpty((CharSequence)formProperty.getName())) {
                    propertyBuilder.append(formProperty.getName());
                } else {
                    propertyBuilder.append(formProperty.getId());
                }
                if (StringUtils.isNotEmpty((CharSequence)formProperty.getType())) {
                    propertyBuilder.append(" - ");
                    propertyBuilder.append(formProperty.getType());
                }
                if (formProperty.isRequired()) {
                    propertyBuilder.append(" (required)");
                } else {
                    propertyBuilder.append(" (not required)");
                }
                formPropertyValues.add(propertyBuilder.toString());
            }
            this.createPropertyNode("Form properties", formPropertyValues);
        }
        this.createListenerPropertyNodes("Task listeners", userTask.getTaskListeners());
        this.createListenerPropertyNodes("Execution listeners", userTask.getExecutionListeners());
    }
}

