/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.query.NativeQuery;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractNativeQuery<T extends NativeQuery<?, ?>, U>
implements Command<Object>,
NativeQuery<T, U>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient CommandExecutor commandExecutor;
    protected transient CommandContext commandContext;
    protected int maxResults = Integer.MAX_VALUE;
    protected int firstResult;
    protected ResultType resultType;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String sqlStatement;

    protected AbstractNativeQuery(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public AbstractNativeQuery(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public AbstractNativeQuery<T, U> setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    @Override
    public T sql(String sqlStatement) {
        this.sqlStatement = sqlStatement;
        return (T)this;
    }

    @Override
    public T parameter(String name, Object value) {
        this.parameters.put(name, value);
        return (T)this;
    }

    @Override
    public U singleResult() {
        this.resultType = ResultType.SINGLE_RESULT;
        if (this.commandExecutor != null) {
            return (U)this.commandExecutor.execute(this);
        }
        return this.executeSingleResult(Context.getCommandContext());
    }

    @Override
    public List<U> list() {
        this.resultType = ResultType.LIST;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.executeList(Context.getCommandContext(), this.getParameterMap(), 0, Integer.MAX_VALUE);
    }

    @Override
    public List<U> listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.resultType = ResultType.LIST_PAGE;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.executeList(Context.getCommandContext(), this.getParameterMap(), firstResult, maxResults);
    }

    @Override
    public long count() {
        this.resultType = ResultType.COUNT;
        if (this.commandExecutor != null) {
            return (Long)this.commandExecutor.execute(this);
        }
        return this.executeCount(Context.getCommandContext(), this.getParameterMap());
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.resultType == ResultType.LIST) {
            return this.executeList(commandContext, this.getParameterMap(), 0, Integer.MAX_VALUE);
        }
        if (this.resultType == ResultType.LIST_PAGE) {
            Map<String, Object> parameterMap = this.getParameterMap();
            parameterMap.put("resultType", "LIST_PAGE");
            parameterMap.put("firstResult", this.firstResult);
            parameterMap.put("maxResults", this.maxResults);
            if (StringUtils.isNotBlank((CharSequence)Objects.toString(parameterMap.get("orderBy"), ""))) {
                parameterMap.put("orderByColumns", "RES." + parameterMap.get("orderBy"));
            } else {
                parameterMap.put("orderByColumns", "RES.ID_ asc");
            }
            int firstRow = this.firstResult + 1;
            parameterMap.put("firstRow", firstRow);
            int lastRow = 0;
            lastRow = this.maxResults == Integer.MAX_VALUE ? this.maxResults : this.firstResult + this.maxResults + 1;
            parameterMap.put("lastRow", lastRow);
            return this.executeList(commandContext, parameterMap, this.firstResult, this.maxResults);
        }
        if (this.resultType == ResultType.SINGLE_RESULT) {
            return this.executeSingleResult(commandContext);
        }
        return this.executeCount(commandContext, this.getParameterMap());
    }

    public abstract long executeCount(CommandContext var1, Map<String, Object> var2);

    public abstract List<U> executeList(CommandContext var1, Map<String, Object> var2, int var3, int var4);

    public U executeSingleResult(CommandContext commandContext) {
        List<U> results = this.executeList(commandContext, this.getParameterMap(), 0, Integer.MAX_VALUE);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            throw new ActivitiException("Query return " + results.size() + " results instead of max 1");
        }
        return null;
    }

    private Map<String, Object> getParameterMap() {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("sql", this.sqlStatement);
        parameterMap.putAll(this.parameters);
        return parameterMap;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    private static enum ResultType {
        LIST,
        LIST_PAGE,
        SINGLE_RESULT,
        COUNT;

    }
}

