/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Iterator;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.flowable.engine.delegate.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExclusiveGatewayActivityBehavior.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void leave(ActivityExecution execution) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Leaving activity '{}'", (Object)execution.getActivity().getId());
        }
        PvmTransition outgoingSeqFlow = null;
        String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
        Iterator<PvmTransition> transitionIterator = execution.getActivity().getOutgoingTransitions().iterator();
        while (outgoingSeqFlow == null && transitionIterator.hasNext()) {
            PvmTransition seqFlow = transitionIterator.next();
            Expression skipExpression = seqFlow.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled(execution, skipExpression)) {
                Condition condition = (Condition)seqFlow.getProperty("condition");
                if ((condition != null || defaultSequenceFlow != null && defaultSequenceFlow.equals(seqFlow.getId())) && (condition == null || !condition.evaluate(seqFlow.getId(), execution))) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Sequence flow '{}'selected as outgoing sequence flow.", (Object)seqFlow.getId());
                }
                outgoingSeqFlow = seqFlow;
                continue;
            }
            if (!SkipExpressionUtil.shouldSkipFlowElement(execution, skipExpression)) continue;
            outgoingSeqFlow = seqFlow;
        }
        if (outgoingSeqFlow != null) {
            execution.take(outgoingSeqFlow);
            return;
        } else {
            if (defaultSequenceFlow == null) throw new ActivitiException("No outgoing sequence flow of the exclusive gateway '" + execution.getActivity().getId() + "' could be selected for continuing the process");
            PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
            if (defaultTransition == null) throw new ActivitiException("Default sequence flow '" + defaultSequenceFlow + "' not found");
            execution.take(defaultTransition);
        }
    }
}

