/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.flowable.engine.delegate.DelegateExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelGatewayActivityBehavior.class);

    @Override
    public void execute(DelegateExecution execution) {
        ActivityExecution activityExecution = (ActivityExecution)execution;
        PvmActivity activity = activityExecution.getActivity();
        List<PvmTransition> outgoingTransitions = activityExecution.getActivity().getOutgoingTransitions();
        execution.inactivate();
        this.lockConcurrentRoot(activityExecution);
        List<ActivityExecution> joinedExecutions = activityExecution.findInactiveConcurrentExecutions(activity);
        int nbrOfExecutionsToJoin = activityExecution.getActivity().getIncomingTransitions().size();
        int nbrOfExecutionsJoined = joinedExecutions.size();
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution);
        if (nbrOfExecutionsJoined == nbrOfExecutionsToJoin) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("parallel gateway '{}' activates: {} of {} joined", new Object[]{activity.getId(), nbrOfExecutionsJoined, nbrOfExecutionsToJoin});
            }
            activityExecution.takeAll(outgoingTransitions, joinedExecutions);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parallel gateway '{}' does not activate: {} of {} joined", new Object[]{activity.getId(), nbrOfExecutionsJoined, nbrOfExecutionsToJoin});
        }
    }
}

