/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.delegate.VariableScope;

public class ServiceTaskExpressionActivityBehavior
extends TaskActivityBehavior {
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    protected String resultVariable;
    protected List<MapExceptionEntry> mapExceptions;

    public ServiceTaskExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, String resultVariable, List<MapExceptionEntry> mapExceptions) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.resultVariable = resultVariable;
        this.mapExceptions = mapExceptions;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ActivityExecution activityExecution = (ActivityExecution)execution;
        Object value = null;
        try {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(activityExecution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(activityExecution, this.skipExpression)) {
                String overrideExpression;
                ObjectNode taskElementProperties;
                if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = Context.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = taskElementProperties.get("serviceTaskExpression").asText())) && !overrideExpression.equals(this.expression.getExpressionText())) {
                    this.expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideExpression);
                }
                value = this.expression.getValue((VariableScope)execution);
                if (this.resultVariable != null) {
                    execution.setVariable(this.resultVariable, value);
                }
            }
            this.leave(activityExecution);
        }
        catch (Exception exc) {
            BpmnError error = null;
            for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                if (cause instanceof BpmnError) {
                    error = (BpmnError)cause;
                    break;
                }
                if (!(cause instanceof RuntimeException) || !ErrorPropagation.mapException((RuntimeException)cause, activityExecution, this.mapExceptions)) continue;
                return;
            }
            if (error != null) {
                ErrorPropagation.propagateError(error, activityExecution);
            }
            throw new ActivitiException(exc.getMessage(), exc);
        }
    }
}

