/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.impl.delegate.event.FlowableEngineEvent;

public class ErrorThrowingEventListener
extends BaseDelegateEventListener {
    protected String errorCode;

    public void onEvent(FlowableEvent event) {
        if (this.isValidEvent(event) && event instanceof FlowableEngineEvent) {
            FlowableEngineEvent engineEvent = (FlowableEngineEvent)event;
            ExecutionEntity execution = null;
            if (Context.isExecutionContextActive()) {
                execution = Context.getExecutionContext().getExecution();
            } else if (engineEvent.getExecutionId() != null) {
                execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(engineEvent.getExecutionId());
            }
            if (execution == null) {
                throw new ActivitiException("No execution context active and event is not related to an execution. No compensation event can be thrown.");
            }
            try {
                ErrorPropagation.propagateError(this.errorCode, (ActivityExecution)execution);
            }
            catch (Exception e) {
                throw new ActivitiException("Error while propagating error-event", e);
            }
        }
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isFailOnException() {
        return true;
    }
}

