/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.impl.delegate.event.FlowableEngineEvent;
import org.flowable.engine.repository.ProcessDefinition;

public class SignalThrowingEventListener
extends BaseDelegateEventListener {
    protected String signalName;
    protected boolean processInstanceScope = true;

    public void onEvent(FlowableEvent event) {
        if (this.isValidEvent(event) && event instanceof FlowableEngineEvent) {
            FlowableEngineEvent engineEvent = (FlowableEngineEvent)event;
            if (engineEvent.getProcessInstanceId() == null && this.processInstanceScope) {
                throw new ActivitiIllegalArgumentException("Cannot throw process-instance scoped signal, since the dispatched event is not part of an ongoing process instance");
            }
            CommandContext commandContext = Context.getCommandContext();
            List<SignalEventSubscriptionEntity> subscriptionEntities = null;
            if (this.processInstanceScope) {
                subscriptionEntities = commandContext.getEventSubscriptionEntityManager().findSignalEventSubscriptionsByProcessInstanceAndEventName(engineEvent.getProcessInstanceId(), this.signalName);
            } else {
                String tenantId = null;
                if (engineEvent.getProcessDefinitionId() != null) {
                    ProcessDefinition processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(engineEvent.getProcessDefinitionId());
                    tenantId = processDefinition.getTenantId();
                }
                subscriptionEntities = commandContext.getEventSubscriptionEntityManager().findSignalEventSubscriptionsByEventName(this.signalName, tenantId);
            }
            for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : subscriptionEntities) {
                signalEventSubscriptionEntity.eventReceived(null, false);
            }
        }
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public void setProcessInstanceScope(boolean processInstanceScope) {
        this.processInstanceScope = processInstanceScope;
    }

    public boolean isFailOnException() {
        return true;
    }
}

