/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundaryEventParseHandler
extends AbstractFlowNodeBpmnParseHandler<BoundaryEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoundaryEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return BoundaryEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, BoundaryEvent boundaryEvent) {
        ActivityImpl parentActivity = this.findActivity(bpmnParse, boundaryEvent.getAttachedToRefId());
        if (parentActivity == null) {
            LOGGER.warn("Invalid reference in boundary event. Make sure that the referenced activity is defined in the same scope as the boundary event {}", (Object)boundaryEvent.getId());
            return;
        }
        ActivityImpl nestedActivity = this.createActivityOnScope(bpmnParse, (FlowElement)boundaryEvent, "boundaryEvent", parentActivity);
        bpmnParse.setCurrentActivity(nestedActivity);
        EventDefinition eventDefinition = null;
        if (!boundaryEvent.getEventDefinitions().isEmpty()) {
            eventDefinition = (EventDefinition)boundaryEvent.getEventDefinitions().get(0);
        }
        if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof ErrorEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof CancelEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof CompensateEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
        } else {
            LOGGER.warn("Unsupported boundary event type for boundary event {}", (Object)boundaryEvent.getId());
        }
    }
}

