/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateCatchEventParseHandler
extends AbstractFlowNodeBpmnParseHandler<IntermediateCatchEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateCatchEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return IntermediateCatchEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, IntermediateCatchEvent event) {
        ActivityImpl nestedActivity = null;
        EventDefinition eventDefinition = null;
        if (!event.getEventDefinitions().isEmpty()) {
            eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
        }
        if (eventDefinition == null) {
            nestedActivity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)event, "intermediateCatchEvent");
            nestedActivity.setAsync(event.isAsynchronous());
            nestedActivity.setExclusive(!event.isNotExclusive());
        } else {
            ScopeImpl scope = bpmnParse.getCurrentScope();
            String eventBasedGatewayId = this.getPrecedingEventBasedGateway(bpmnParse, event);
            if (eventBasedGatewayId != null) {
                ActivityImpl gatewayActivity = scope.findActivity(eventBasedGatewayId);
                nestedActivity = this.createActivityOnScope(bpmnParse, (FlowElement)event, "intermediateCatchEvent", gatewayActivity);
            } else {
                nestedActivity = this.createActivityOnScope(bpmnParse, (FlowElement)event, "intermediateCatchEvent", scope);
            }
            nestedActivity.setAsync(event.isAsynchronous());
            nestedActivity.setExclusive(!event.isNotExclusive());
            nestedActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createIntermediateCatchEventActivityBehavior(event));
            if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof MessageEventDefinition) {
                bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
            } else {
                LOGGER.warn("Unsupported intermediate catch event type for event {}", (Object)event.getId());
            }
        }
    }
}

