/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Transaction;
import org.flowable.engine.impl.bpmn.data.IOSpecification;

public class TransactionParseHandler
extends AbstractActivityBpmnParseHandler<Transaction> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return Transaction.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, Transaction transaction) {
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)transaction, "transaction");
        activity.setAsync(transaction.isAsynchronous());
        activity.setExclusive(!transaction.isNotExclusive());
        activity.setScope(true);
        activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createTransactionActivityBehavior(transaction));
        bpmnParse.setCurrentScope(activity);
        bpmnParse.processFlowElements(transaction.getFlowElements());
        this.processArtifacts(bpmnParse, transaction.getArtifacts(), activity);
        bpmnParse.removeCurrentScope();
        if (transaction.getIoSpecification() != null) {
            IOSpecification ioSpecification = this.createIOSpecification(bpmnParse, transaction.getIoSpecification());
            activity.setIoSpecification(ioSpecification);
        }
    }
}

