/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteJobCmd
implements Command<Object>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteJobCmd.class);
    private static final long serialVersionUID = 1L;
    protected String jobId;

    public DeleteJobCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobEntity jobToDelete = this.getJobToDelete(commandContext);
        jobToDelete.delete();
        return null;
    }

    protected JobEntity getJobToDelete(CommandContext commandContext) {
        JobEntity job;
        if (this.jobId == null) {
            throw new ActivitiIllegalArgumentException("jobId is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleting job {}", (Object)this.jobId);
        }
        if ((job = commandContext.getJobEntityManager().findJobById(this.jobId)) == null) {
            throw new ActivitiObjectNotFoundException("No job found with id '" + this.jobId + "'", Job.class);
        }
        if (job.getLockOwner() != null) {
            throw new ActivitiException("Cannot delete job when the job is being executed. Try again later.");
        }
        return job;
    }
}

