/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Execution;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.impl.persistence.entity.VariableInstance;

public class GetExecutionVariableInstanceCmd
implements Command<VariableInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String variableName;
    protected boolean isLocal;

    public GetExecutionVariableInstanceCmd(String executionId, String variableName, boolean isLocal) {
        this.executionId = executionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public VariableInstance execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new FlowableIllegalArgumentException("executionId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new FlowableObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        VariableInstance variableEntity = null;
        variableEntity = this.isLocal ? execution.getVariableInstanceLocal(this.variableName, false) : execution.getVariableInstance(this.variableName, false);
        return variableEntity;
    }
}

