/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.engine.impl.persistence.entity.VariableInstance;

public class GetExecutionsVariablesCmd
implements Command<List<VariableInstance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<String> executionIds;

    public GetExecutionsVariablesCmd(Set<String> executionIds) {
        this.executionIds = executionIds;
    }

    @Override
    public List<VariableInstance> execute(CommandContext commandContext) {
        if (this.executionIds == null) {
            throw new ActivitiIllegalArgumentException("executionIds is null");
        }
        if (this.executionIds.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Set of executionIds is empty");
        }
        ArrayList<VariableInstance> instances = new ArrayList<VariableInstance>();
        List<VariableInstanceEntity> entities = commandContext.getVariableInstanceEntityManager().findVariableInstancesByExecutionIds(this.executionIds);
        for (VariableInstanceEntity entity : entities) {
            entity.getValue();
            instances.add(entity);
        }
        return instances;
    }
}

