/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.AbstractJobEntity;
import org.activiti.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.runtime.ClockReader;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.impl.calendar.DurationHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRetryCmd
implements Command<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JobRetryCmd.class.getName());
    protected String jobId;
    protected Throwable exception;

    public JobRetryCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobEntity job = commandContext.getJobEntityManager().findJobById(this.jobId);
        if (job == null) {
            return null;
        }
        ActivityImpl activity = this.getCurrentActivity(commandContext, job);
        ProcessEngineConfigurationImpl processEngineConfig = commandContext.getProcessEngineConfiguration();
        AbstractJobEntity newJobEntity = null;
        if (activity == null || activity.getFailedJobRetryTimeCycleValue() == null) {
            LOGGER.debug("activity or FailedJobRetryTimerCycleValue is null in job '{}'. Only decrementing retries.", (Object)this.jobId);
            if (job.getRetries() <= 1) {
                DeadLetterJobEntity deadLetterJob = new DeadLetterJobEntity(job);
                deadLetterJob.insert();
                newJobEntity = deadLetterJob;
            } else {
                TimerJobEntity timerJob = new TimerJobEntity(job);
                timerJob.insert();
                newJobEntity = timerJob;
            }
            newJobEntity.setRetries(job.getRetries() - 1);
            if (job.getDuedate() == null) {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, processEngineConfig.getAsyncFailedJobWaitTime(), null));
            } else {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, processEngineConfig.getDefaultFailedJobWaitTime(), job.getDuedate()));
            }
        } else {
            String failedJobRetryTimeCycle = activity.getFailedJobRetryTimeCycleValue();
            try {
                DurationHelper durationHelper = new DurationHelper(failedJobRetryTimeCycle, (ClockReader)processEngineConfig.getClock());
                int jobRetries = job.getRetries();
                if (job.getExceptionMessage() == null) {
                    jobRetries = durationHelper.getTimes();
                }
                if (job.getRetries() <= 1) {
                    DeadLetterJobEntity deadLetterJob = new DeadLetterJobEntity(job);
                    deadLetterJob.insert();
                    newJobEntity = deadLetterJob;
                } else {
                    TimerJobEntity timerJob = new TimerJobEntity(job);
                    timerJob.insert();
                    newJobEntity = timerJob;
                }
                newJobEntity.setDuedate(durationHelper.getDateAfter());
                if (job.getExceptionMessage() == null) {
                    LOGGER.debug("Applying JobRetryStrategy '{}' the first time for job {} with {} retries", new Object[]{failedJobRetryTimeCycle, job.getId(), durationHelper.getTimes()});
                } else {
                    LOGGER.debug("Decrementing retries of JobRetryStrategy '{}' for job {}", (Object)failedJobRetryTimeCycle, (Object)job.getId());
                }
                newJobEntity.setRetries(jobRetries - 1);
            }
            catch (Exception e) {
                throw new ActivitiException("failedJobRetryTimeCycle has wrong format:" + failedJobRetryTimeCycle, this.exception);
            }
        }
        if (this.exception != null) {
            newJobEntity.setExceptionMessage(this.exception.getMessage());
            newJobEntity.setExceptionStacktrace(this.getExceptionStacktrace());
        }
        job.delete();
        FlowableEventDispatcher eventDispatcher = commandContext.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, newJobEntity));
            eventDispatcher.dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_RETRIES_DECREMENTED, newJobEntity));
        }
        return null;
    }

    protected Date calculateDueDate(CommandContext commandContext, int waitTimeInSeconds, Date oldDate) {
        GregorianCalendar newDateCal = new GregorianCalendar();
        if (oldDate != null) {
            newDateCal.setTime(oldDate);
        } else {
            newDateCal.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        }
        ((Calendar)newDateCal).add(13, waitTimeInSeconds);
        return newDateCal.getTime();
    }

    private ActivityImpl getCurrentActivity(CommandContext commandContext, Job job) {
        ExecutionEntity execution;
        String type = job.getJobHandlerType();
        ActivityImpl activity = null;
        if ("timer-transition".equals(type) || "timer-intermediate-transition".equals(type)) {
            ExecutionEntity execution2 = this.fetchExecutionEntity(commandContext, job.getExecutionId());
            if (execution2 != null) {
                activity = execution2.getProcessDefinition().findActivity(job.getJobHandlerConfiguration());
            }
        } else if ("timer-start-event".equals(type)) {
            DeploymentManager deploymentManager = commandContext.getProcessEngineConfiguration().getDeploymentManager();
            if (TimerEventHandler.hasRealActivityId(job.getJobHandlerConfiguration())) {
                ProcessDefinition processDefinition = deploymentManager.findDeployedProcessDefinitionById(job.getProcessDefinitionId());
                String activityId = TimerEventHandler.getActivityIdFromConfiguration(job.getJobHandlerConfiguration());
                activity = ((ProcessDefinitionEntity)processDefinition).findActivity(activityId);
            } else {
                String processId = job.getJobHandlerConfiguration();
                if (job instanceof TimerJobEntity) {
                    processId = TimerEventHandler.getActivityIdFromConfiguration(job.getJobHandlerConfiguration());
                }
                ProcessDefinition processDefinition = null;
                processDefinition = job.getTenantId() != null && job.getTenantId().length() > 0 ? deploymentManager.findDeployedLatestProcessDefinitionByKeyAndTenantId(processId, job.getTenantId()) : deploymentManager.findDeployedLatestProcessDefinitionByKey(processId);
                if (processDefinition != null) {
                    activity = ((ProcessDefinitionEntity)processDefinition).getInitial();
                }
            }
        } else if ("async-continuation".equals(type) && (execution = this.fetchExecutionEntity(commandContext, job.getExecutionId())) != null) {
            activity = execution.getActivity();
        }
        return activity;
    }

    private String getExceptionStacktrace() {
        StringWriter stringWriter = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private ExecutionEntity fetchExecutionEntity(CommandContext commandContext, String executionId) {
        return commandContext.getExecutionEntityManager().findExecutionById(executionId);
    }
}

