/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.Attachment;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.FlowableEngineEventType;

public class SaveAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Attachment attachment;

    public SaveAttachmentCmd(Attachment attachment) {
        this.attachment = attachment;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        AttachmentEntity updateAttachment = commandContext.getDbSqlSession().selectById(AttachmentEntity.class, this.attachment.getId());
        updateAttachment.setName(this.attachment.getName());
        updateAttachment.setDescription(this.attachment.getDescription());
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = updateAttachment.getProcessInstanceId();
            if (updateAttachment.getProcessInstanceId() != null && (process = commandContext.getExecutionEntityManager().findExecutionById(processInstanceId)) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, this.attachment, processInstanceId, processInstanceId, processDefinitionId));
        }
        return null;
    }
}

