/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.form.FormDataImpl;
import org.activiti.engine.impl.form.FormHandler;
import org.activiti.engine.impl.form.FormPropertyHandler;
import org.activiti.engine.impl.form.FormTypes;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FormProperty;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.form.AbstractFormType;
import org.flowable.engine.repository.ProcessDefinition;

public class DefaultFormHandler
implements FormHandler {
    protected Expression formKey;
    protected String deploymentId;
    protected List<FormPropertyHandler> formPropertyHandlers = new ArrayList<FormPropertyHandler>();

    @Override
    public void parseConfiguration(List<FormProperty> formProperties, String formKey, DeploymentEntity deployment, ProcessDefinition processDefinition) {
        this.deploymentId = deployment.getId();
        ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)formKey)) {
            this.formKey = expressionManager.createExpression(formKey);
        }
        FormTypes formTypes = Context.getProcessEngineConfiguration().getFormTypes();
        for (FormProperty formProperty : formProperties) {
            FormPropertyHandler formPropertyHandler = new FormPropertyHandler();
            formPropertyHandler.setId(formProperty.getId());
            formPropertyHandler.setName(formProperty.getName());
            AbstractFormType type = formTypes.parseFormPropertyType(formProperty);
            formPropertyHandler.setType(type);
            formPropertyHandler.setRequired(formProperty.isRequired());
            formPropertyHandler.setReadable(formProperty.isReadable());
            formPropertyHandler.setWritable(formProperty.isWriteable());
            formPropertyHandler.setVariableName(formProperty.getVariable());
            if (StringUtils.isNotEmpty((CharSequence)formProperty.getExpression())) {
                Expression expression = expressionManager.createExpression(formProperty.getExpression());
                formPropertyHandler.setVariableExpression(expression);
            }
            if (StringUtils.isNotEmpty((CharSequence)formProperty.getDefaultExpression())) {
                Expression defaultExpression = expressionManager.createExpression(formProperty.getDefaultExpression());
                formPropertyHandler.setDefaultExpression(defaultExpression);
            }
            this.formPropertyHandlers.add(formPropertyHandler);
        }
    }

    protected void initializeFormProperties(FormDataImpl formData, ExecutionEntity execution) {
        ArrayList<org.flowable.engine.form.FormProperty> formProperties = new ArrayList<org.flowable.engine.form.FormProperty>();
        for (FormPropertyHandler formPropertyHandler : this.formPropertyHandlers) {
            if (!formPropertyHandler.isReadable()) continue;
            org.flowable.engine.form.FormProperty formProperty = formPropertyHandler.createFormProperty(execution);
            formProperties.add(formProperty);
        }
        formData.setFormProperties(formProperties);
    }

    @Override
    public void submitFormProperties(Map<String, String> properties, ExecutionEntity execution) {
        HashMap<String, String> propertiesCopy = new HashMap<String, String>(properties);
        for (FormPropertyHandler formPropertyHandler : this.formPropertyHandlers) {
            formPropertyHandler.submitFormProperty(execution, propertiesCopy);
        }
        for (String propertyId : propertiesCopy.keySet()) {
            execution.setVariable(propertyId, propertiesCopy.get(propertyId));
        }
    }

    public Expression getFormKey() {
        return this.formKey;
    }

    public void setFormKey(Expression formKey) {
        this.formKey = formKey;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public List<FormPropertyHandler> getFormPropertyHandlers() {
        return this.formPropertyHandlers;
    }

    public void setFormPropertyHandlers(List<FormPropertyHandler> formPropertyHandlers) {
        this.formPropertyHandlers = formPropertyHandlers;
    }
}

