/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import org.activiti.engine.impl.util.json.JSONException;
import org.activiti.engine.impl.util.json.JSONObject;
import org.flowable.engine.delegate.Expression;

public class TimerEventHandler {
    public static final String PROPERTYNAME_TIMER_ACTIVITY_ID = "activityId";
    public static final String PROPERTYNAME_END_DATE_EXPRESSION = "timerEndDate";
    public static final String PROPERTYNAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    public static final String PROPERTYNAME_CALENDAR_NAME_EXPRESSION = "calendarName";

    public static String createConfiguration(String id, Expression endDate, Expression calendarName) {
        JSONObject cfgJson = new JSONObject();
        cfgJson.put(PROPERTYNAME_TIMER_ACTIVITY_ID, id);
        if (endDate != null) {
            cfgJson.put(PROPERTYNAME_END_DATE_EXPRESSION, endDate.getExpressionText());
        }
        if (calendarName != null) {
            cfgJson.put(PROPERTYNAME_CALENDAR_NAME_EXPRESSION, calendarName.getExpressionText());
        }
        return cfgJson.toString();
    }

    public String setActivityIdToConfiguration(String jobHandlerConfiguration, String activityId) {
        try {
            JSONObject cfgJson = new JSONObject(jobHandlerConfiguration);
            cfgJson.put(PROPERTYNAME_TIMER_ACTIVITY_ID, activityId);
            return cfgJson.toString();
        }
        catch (JSONException ex) {
            return jobHandlerConfiguration;
        }
    }

    public static String getActivityIdFromConfiguration(String jobHandlerConfiguration) {
        try {
            JSONObject cfgJson = new JSONObject(jobHandlerConfiguration);
            return cfgJson.get(PROPERTYNAME_TIMER_ACTIVITY_ID).toString();
        }
        catch (JSONException ex) {
            return jobHandlerConfiguration;
        }
    }

    public static String geCalendarNameFromConfiguration(String jobHandlerConfiguration) {
        try {
            JSONObject cfgJson = new JSONObject(jobHandlerConfiguration);
            return cfgJson.get(PROPERTYNAME_CALENDAR_NAME_EXPRESSION).toString();
        }
        catch (JSONException ex) {
            return "";
        }
    }

    public String setEndDateToConfiguration(String jobHandlerConfiguration, String endDate) {
        JSONObject cfgJson = null;
        try {
            cfgJson = new JSONObject(jobHandlerConfiguration);
        }
        catch (JSONException ex) {
            cfgJson = new JSONObject();
            cfgJson.put(PROPERTYNAME_TIMER_ACTIVITY_ID, jobHandlerConfiguration);
        }
        if (endDate != null) {
            cfgJson.put(PROPERTYNAME_END_DATE_EXPRESSION, endDate);
        }
        return cfgJson.toString();
    }

    public static String getEndDateFromConfiguration(String jobHandlerConfiguration) {
        try {
            JSONObject cfgJson = new JSONObject(jobHandlerConfiguration);
            return cfgJson.get(PROPERTYNAME_END_DATE_EXPRESSION).toString();
        }
        catch (JSONException ex) {
            return null;
        }
    }

    public String setProcessDefinitionKeyToConfiguration(String jobHandlerConfiguration, String activityId) {
        try {
            JSONObject cfgJson = new JSONObject(jobHandlerConfiguration);
            cfgJson.put(PROPERTYNAME_PROCESS_DEFINITION_KEY, activityId);
            return cfgJson.toString();
        }
        catch (JSONException ex) {
            return jobHandlerConfiguration;
        }
    }

    public String getProcessDefinitionKeyFromConfiguration(String jobHandlerConfiguration) {
        try {
            JSONObject cfgJson = new JSONObject(jobHandlerConfiguration);
            return cfgJson.get(PROPERTYNAME_PROCESS_DEFINITION_KEY).toString();
        }
        catch (JSONException ex) {
            return null;
        }
    }

    public static boolean hasRealActivityId(String jobHandlerConfiguration) {
        try {
            JSONObject cfgJson = new JSONObject(jobHandlerConfiguration);
            Object processDefinitionKey = cfgJson.get(PROPERTYNAME_PROCESS_DEFINITION_KEY);
            if (processDefinitionKey != null) {
                return processDefinitionKey.toString().length() > 0;
            }
        }
        catch (JSONException ex) {
            return false;
        }
        return false;
    }
}

