/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.history.HistoryManager;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.activiti.engine.impl.persistence.entity.DeadLetterJobEntityManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.SuspendedJobEntity;
import org.activiti.engine.impl.persistence.entity.SuspendedJobEntityManager;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.impl.persistence.entity.VariableInitializingList;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableScopeImpl;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmException;
import org.activiti.engine.impl.pvm.PvmExecution;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.ExecutionListenerExecution;
import org.activiti.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.impl.pvm.runtime.OutgoingExecution;
import org.activiti.engine.impl.pvm.runtime.StartingExecution;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEntity
extends VariableScopeImpl
implements ActivityExecution,
ExecutionListenerExecution,
Execution,
PvmExecution,
ProcessInstance,
InterpretableExecution,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionEntity.class);
    protected static final int EVENT_SUBSCRIPTIONS_STATE_BIT = 1;
    protected static final int TASKS_STATE_BIT = 2;
    protected static final int JOBS_STATE_BIT = 3;
    protected ProcessDefinitionImpl processDefinition;
    protected ActivityImpl activity;
    protected FlowElement currentFlowElement;
    protected TransitionImpl transition;
    protected TransitionImpl transitionBeingTaken;
    protected ExecutionEntity processInstance;
    protected ExecutionEntity parent;
    protected List<ExecutionEntity> executions;
    protected ExecutionEntity superExecution;
    protected ExecutionEntity subProcessInstance;
    protected StartingExecution startingExecution;
    protected String tenantId = "";
    protected String name;
    protected String description;
    protected String localizedName;
    protected String localizedDescription;
    protected Date lockTime;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent;
    protected boolean isEnded;
    protected boolean isEventScope;
    protected String eventName;
    protected PvmProcessElement eventSource;
    protected int executionListenerIndex;
    protected List<EventSubscriptionEntity> eventSubscriptions;
    protected List<JobEntity> jobs;
    protected List<TimerJobEntity> timerJobs;
    protected List<TaskEntity> tasks;
    protected List<IdentityLinkEntity> identityLinks;
    protected int cachedEntityState;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected ExecutionEntity replacedBy;
    protected AtomicOperation nextOperation;
    protected boolean isOperating;
    protected int revision = 1;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionName;
    protected Integer processDefinitionVersion;
    protected String deploymentId;
    protected String activityId;
    protected String activityName;
    protected String processInstanceId;
    protected String businessKey;
    protected String parentId;
    protected String superExecutionId;
    protected boolean forcedUpdate;
    protected List<VariableInstanceEntity> queryVariables;

    public ExecutionEntity(ActivityImpl activityImpl) {
        this.startingExecution = new StartingExecution(activityImpl);
    }

    public ExecutionEntity() {
    }

    @Override
    public ExecutionEntity createExecution() {
        ExecutionEntity createdExecution = this.newExecution();
        this.ensureExecutionsInitialized();
        this.executions.add(createdExecution);
        createdExecution.setParent(this);
        createdExecution.setProcessDefinition(this.getProcessDefinition());
        createdExecution.setProcessInstance(this.getProcessInstance());
        createdExecution.setActivity(this.getActivity());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Child execution {} created with parent {}", (Object)createdExecution, (Object)this);
        }
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, createdExecution));
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, createdExecution));
        }
        return createdExecution;
    }

    @Override
    public PvmProcessInstance createSubProcessInstance(PvmProcessDefinition processDefinition) {
        ExecutionEntity subProcessInstance = this.newExecution();
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        Context.getCommandContext().getHistoryManager().recordSubProcessInstanceStart(this, subProcessInstance);
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, subProcessInstance));
        }
        return subProcessInstance;
    }

    protected ExecutionEntity newExecution() {
        ExecutionEntity newExecution = new ExecutionEntity();
        newExecution.executions = new ArrayList<ExecutionEntity>();
        if (this.getTenantId() != null) {
            newExecution.setTenantId(this.getTenantId());
        }
        Context.getCommandContext().getDbSqlSession().insert(newExecution);
        return newExecution;
    }

    @Override
    public void initialize() {
        List eventSubscriptionDeclarations;
        LOGGER.debug("initializing {}", (Object)this);
        ScopeImpl scope = this.getScopeObject();
        this.ensureParentInitialized();
        this.variableInstances = new HashMap();
        this.eventSubscriptions = new ArrayList<EventSubscriptionEntity>();
        this.cachedEntityState = 0;
        List timerDeclarations = (List)scope.getProperty("timerDeclarations");
        if (timerDeclarations != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                TimerJobEntity timer = timerDeclaration.prepareTimerEntity(this);
                if (timer == null) continue;
                Context.getCommandContext().getJobEntityManager().schedule(timer);
            }
        }
        if ((eventSubscriptionDeclarations = (List)scope.getProperty("eventDefinitions")) != null) {
            for (EventSubscriptionDeclaration eventSubscriptionDeclaration : eventSubscriptionDeclarations) {
                if (eventSubscriptionDeclaration.isStartEvent()) continue;
                EventSubscriptionEntity eventSubscriptionEntity = eventSubscriptionDeclaration.prepareEventSubscriptionEntity(this);
                if (this.getTenantId() != null) {
                    eventSubscriptionEntity.setTenantId(this.getTenantId());
                }
                eventSubscriptionEntity.insert();
            }
        }
    }

    @Override
    public void start() {
        if (this.startingExecution == null && this.isProcessInstanceType()) {
            this.startingExecution = new StartingExecution(this.processDefinition.getInitial());
        }
        this.performOperation(AtomicOperation.PROCESS_START);
    }

    @Override
    public void destroy() {
        LOGGER.debug("destroying {}", (Object)this);
        this.ensureParentInitialized();
        this.deleteVariablesInstanceForLeavingScope();
        this.setScope(false);
    }

    @Override
    public void end() {
        this.isActive = false;
        this.isEnded = true;
        this.performOperation(AtomicOperation.ACTIVITY_END);
    }

    @Override
    public void signal(String signalName, Object signalData) {
        this.ensureActivityInitialized();
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            boolean isUserTask;
            String signalledActivityId = this.activity.getId();
            activityBehavior.signal(this, signalName, signalData);
            boolean bl = isUserTask = activityBehavior instanceof UserTaskActivityBehavior || activityBehavior instanceof MultiInstanceActivityBehavior && ((MultiInstanceActivityBehavior)activityBehavior).getInnerActivityBehavior() instanceof UserTaskActivityBehavior;
            if (!isUserTask && Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNALED, signalledActivityId, signalName, signalData, this.id, this.processInstanceId, this.processDefinitionId));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void take(PvmTransition transition) {
        this.take(transition, true);
    }

    @Override
    public void take(PvmTransition transition, boolean fireActivityCompletionEvent) {
        if (fireActivityCompletionEvent) {
            this.fireActivityCompletedEvent();
        }
        if (this.transition != null) {
            throw new PvmException("already taking a transition");
        }
        if (transition == null) {
            throw new PvmException("transition is null");
        }
        this.setActivity((ActivityImpl)transition.getSource());
        this.setTransition((TransitionImpl)transition);
        this.performOperation(AtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        this.setActivity((ActivityImpl)activity);
        this.performOperation(AtomicOperation.ACTIVITY_START);
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        ArrayList<ActivityExecution> otherConcurrentExecutions = new ArrayList<ActivityExecution>();
        if (this.isConcurrent()) {
            List<ExecutionEntity> concurrentExecutions = this.getParent().getAllChildExecutions();
            for (ActivityExecution activityExecution : concurrentExecutions) {
                if (activityExecution.getActivity() != null && activityExecution.getActivity().getId().equals(activity.getId())) {
                    if (activityExecution.isActive()) continue;
                    inactiveConcurrentExecutionsInActivity.add(activityExecution);
                    continue;
                }
                otherConcurrentExecutions.add(activityExecution);
            }
        } else if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        } else {
            otherConcurrentExecutions.add(this);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("inactive concurrent executions in '{}': {}", (Object)activity, inactiveConcurrentExecutionsInActivity);
            LOGGER.debug("other concurrent executions: {}", otherConcurrentExecutions);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    protected List<ExecutionEntity> getAllChildExecutions() {
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity childExecution : this.getExecutions()) {
            childExecutions.add(childExecution);
            childExecutions.addAll(childExecution.getAllChildExecutions());
        }
        return childExecutions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void takeAll(List<PvmTransition> transitions, List<ActivityExecution> recyclableExecutions) {
        this.fireActivityCompletedEvent();
        transitions = new ArrayList<PvmTransition>(transitions);
        List<ActivityExecution> list = recyclableExecutions = recyclableExecutions != null ? new ArrayList<ActivityExecution>(recyclableExecutions) : new ArrayList();
        if (recyclableExecutions.size() > 1) {
            for (ActivityExecution recyclableExecution : recyclableExecutions) {
                if (!((ExecutionEntity)recyclableExecution).isScope()) continue;
                throw new PvmException("joining scope executions is not allowed");
            }
        }
        ExecutionEntity concurrentRoot = this.isConcurrent && !this.isScope ? this.getParent() : this;
        ArrayList<ExecutionEntity> concurrentActiveExecutions = new ArrayList<ExecutionEntity>();
        ArrayList<ExecutionEntity> concurrentInActiveExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity executionEntity : concurrentRoot.getExecutions()) {
            if (executionEntity.isActive()) {
                concurrentActiveExecutions.add(executionEntity);
                continue;
            }
            concurrentInActiveExecutions.add(executionEntity);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("transitions to take concurrent: {}", transitions);
            LOGGER.debug("active concurrent executions: {}", concurrentActiveExecutions);
        }
        if (transitions.size() == 1 && concurrentActiveExecutions.isEmpty() && this.allExecutionsInSameActivity(concurrentInActiveExecutions)) {
            List<ActivityExecution> recyclableExecutionImpls = recyclableExecutions;
            recyclableExecutions.remove(concurrentRoot);
            for (ExecutionEntity executionEntity : recyclableExecutionImpls) {
                Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity);
                LOGGER.debug("pruning execution {}", (Object)executionEntity);
                executionEntity.remove();
            }
            LOGGER.debug("activating the concurrent root {} as the single path of execution going forward", (Object)concurrentRoot);
            concurrentRoot.setActive(true);
            concurrentRoot.setActivity(this.activity);
            concurrentRoot.setConcurrent(false);
            concurrentRoot.take(transitions.get(0), false);
        } else {
            ArrayList<OutgoingExecution> outgoingExecutions = new ArrayList<OutgoingExecution>();
            recyclableExecutions.remove(concurrentRoot);
            LOGGER.debug("recyclable executions for reuse: {}", recyclableExecutions);
            while (!transitions.isEmpty()) {
                void var8_14;
                PvmTransition pvmTransition = transitions.remove(0);
                Object var8_15 = null;
                if (recyclableExecutions.isEmpty()) {
                    ExecutionEntity executionEntity = concurrentRoot.createExecution();
                    LOGGER.debug("new {} with parent {} created to take transition {}", new Object[]{executionEntity, executionEntity.getParent(), pvmTransition});
                } else {
                    ExecutionEntity executionEntity = (ExecutionEntity)recyclableExecutions.remove(0);
                    LOGGER.debug("recycled {} to take transition {}", (Object)executionEntity, (Object)pvmTransition);
                }
                var8_14.setActive(true);
                var8_14.setScope(false);
                var8_14.setConcurrent(true);
                var8_14.setTransitionBeingTaken((TransitionImpl)pvmTransition);
                outgoingExecutions.add(new OutgoingExecution((InterpretableExecution)var8_14, pvmTransition, true));
            }
            for (ActivityExecution activityExecution : recyclableExecutions) {
                LOGGER.debug("pruning execution {}", (Object)activityExecution);
                activityExecution.end();
            }
            for (OutgoingExecution outgoingExecution : outgoingExecutions) {
                outgoingExecution.take(false);
            }
        }
    }

    protected void fireActivityCompletedEvent() {
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_COMPLETED, this.getActivity() != null ? this.getActivity().getId() : this.getActivityId(), this.getActivity() != null ? (String)this.getActivity().getProperties().get("name") : null, this.getId(), this.getProcessInstanceId(), this.getProcessDefinitionId(), this.getActivity() != null ? (String)this.getActivity().getProperties().get("type") : null, this.getActivity() != null ? this.getActivity().getActivityBehavior().getClass().getCanonicalName() : null));
        }
    }

    protected boolean allExecutionsInSameActivity(List<ExecutionEntity> executions) {
        if (executions.size() > 1) {
            String activityId = executions.get(0).getActivityId();
            for (ExecutionEntity execution : executions) {
                String otherActivityId = execution.getActivityId();
                if (execution.isEnded || !(activityId == null && otherActivityId != null || activityId != null && otherActivityId == null) && (activityId == null || otherActivityId == null || otherActivityId.equals(activityId))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void performOperation(AtomicOperation executionOperation) {
        if (executionOperation.isAsync(this)) {
            this.scheduleAtomicOperationAsync(executionOperation);
        } else {
            this.performOperationSync(executionOperation);
        }
    }

    protected void performOperationSync(AtomicOperation executionOperation) {
        Context.getCommandContext().performOperation(executionOperation, this);
    }

    protected void scheduleAtomicOperationAsync(AtomicOperation executionOperation) {
        JobEntity message = new JobEntity();
        message.setJobType("message");
        message.setRevision(1);
        message.setExecution(this);
        message.setExclusive(this.getActivity().isExclusive());
        message.setJobHandlerType("async-continuation");
        ProcessEngineConfigurationImpl processEngineConfig = Context.getCommandContext().getProcessEngineConfiguration();
        if (processEngineConfig.getAsyncExecutor().isActive()) {
            GregorianCalendar expireCal = new GregorianCalendar();
            expireCal.setTime(processEngineConfig.getClock().getCurrentTime());
            expireCal.add(13, processEngineConfig.getLockTimeAsyncJobWaitTime());
            message.setLockExpirationTime(expireCal.getTime());
        }
        if (this.getTenantId() != null) {
            message.setTenantId(this.getTenantId());
        }
        Context.getCommandContext().getJobEntityManager().send(message);
    }

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public List<ExecutionEntity> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            this.executions = Context.getCommandContext().getExecutionEntityManager().findChildExecutionsByParentExecutionId(this.id);
        }
    }

    public void setExecutions(List<ExecutionEntity> executions) {
        this.executions = executions;
    }

    @Override
    public ExecutionEntity findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (ExecutionEntity nestedExecution : this.getExecutions()) {
            ExecutionEntity result = nestedExecution.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        this.ensureActivityInitialized();
        if (this.isActive && this.activity != null) {
            activeActivityIds.add(this.activity.getId());
        }
        this.ensureExecutionsInitialized();
        for (ExecutionEntity execution : this.executions) {
            execution.collectActiveActivityIds(activeActivityIds);
        }
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    public String getProcessInstanceBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        this.ensureProcessDefinitionInitialized();
        return this.processDefinition;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @Override
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    protected void ensureProcessDefinitionInitialized() {
        if (this.processDefinition == null && this.processDefinitionId != null) {
            ProcessDefinitionEntity deployedProcessDefinition = (ProcessDefinitionEntity)Context.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
            this.setProcessDefinition(deployedProcessDefinition);
        }
    }

    @Override
    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
        this.processDefinitionId = processDefinition.getId();
        this.processDefinitionKey = processDefinition.getKey();
    }

    @Override
    public ExecutionEntity getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.processInstanceId);
        }
    }

    @Override
    public void setProcessInstance(InterpretableExecution processInstance) {
        this.processInstance = (ExecutionEntity)processInstance;
        if (processInstance != null) {
            this.processInstanceId = this.processInstance.getId();
        }
    }

    @Override
    public boolean isProcessInstanceType() {
        return this.parentId == null;
    }

    @Override
    public ActivityImpl getActivity() {
        this.ensureActivityInitialized();
        return this.activity;
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.activity = this.getProcessDefinition().findActivity(this.activityId);
        }
    }

    @Override
    public void setActivity(ActivityImpl activity) {
        this.activity = activity;
        if (activity != null) {
            this.activityId = activity.getId();
            this.activityName = (String)activity.getProperty("name");
        } else {
            this.activityId = null;
            this.activityName = null;
        }
    }

    @Override
    public ExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            this.parent = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.parentId);
        }
    }

    @Override
    public void setParent(InterpretableExecution parent) {
        this.parent = (ExecutionEntity)parent;
        this.parentId = parent != null ? ((ExecutionEntity)parent).getId() : null;
    }

    @Override
    public String getSuperExecutionId() {
        return this.superExecutionId;
    }

    @Override
    public ExecutionEntity getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    public void setSuperExecution(ExecutionEntity superExecution) {
        this.superExecution = superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
        this.superExecutionId = superExecution != null ? superExecution.getId() : null;
    }

    protected void ensureSuperExecutionInitialized() {
        if (this.superExecution == null && this.superExecutionId != null) {
            this.superExecution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.superExecutionId);
        }
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(InterpretableExecution subProcessInstance) {
        this.subProcessInstance = (ExecutionEntity)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(this.id);
        }
    }

    protected ScopeImpl getScopeObject() {
        ScopeImpl scope = null;
        scope = this.isProcessInstanceType() ? this.getProcessDefinition() : this.getActivity();
        return scope;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public void remove() {
        this.ensureParentInitialized();
        if (this.parent != null) {
            this.parent.ensureExecutionsInitialized();
            this.parent.executions.remove(this);
        }
        this.ensureVariableInstancesInitialized();
        this.deleteVariablesInstanceForLeavingScope();
        this.removeTasks(null);
        this.removeJobs();
        this.removeEventSubscriptions();
        this.removeEventScopes();
        this.removeIdentityLinks();
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, this));
        }
        Context.getCommandContext().getDbSqlSession().delete(this);
    }

    @Override
    public void destroyScope(String reason) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("performing destroy scope behavior for execution {}", (Object)this);
        }
        HistoryManager historyManager = Context.getCommandContext().getHistoryManager();
        ArrayList<ExecutionEntity> executions = new ArrayList<ExecutionEntity>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : executions) {
            if (interpretableExecution.getSubProcessInstance() != null) {
                interpretableExecution.getSubProcessInstance().deleteCascade(reason);
            }
            historyManager.recordActivityEnd((ExecutionEntity)interpretableExecution);
            interpretableExecution.deleteCascade(reason);
        }
        if (this.activityId != null) {
            historyManager.recordActivityEnd(this);
        }
        this.removeTasks(reason);
        this.removeJobs();
    }

    private void removeEventScopes() {
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : childExecutions) {
            if (!interpretableExecution.isEventScope()) continue;
            LOGGER.debug("removing eventScope {}", (Object)interpretableExecution);
            interpretableExecution.destroy();
            interpretableExecution.remove();
        }
    }

    private void removeEventSubscriptions() {
        for (EventSubscriptionEntity eventSubscription : this.getEventSubscriptions()) {
            eventSubscription.delete();
        }
    }

    private void removeJobs() {
        for (Job job : this.getJobs()) {
            ((JobEntity)job).delete();
        }
        for (Job job : this.getTimerJobs()) {
            ((TimerJobEntity)job).delete();
        }
        SuspendedJobEntityManager suspendedJobEntityManager = Context.getCommandContext().getSuspendedJobEntityManager();
        List<SuspendedJobEntity> list = suspendedJobEntityManager.findSuspendedJobsByExecutionId(this.id);
        for (SuspendedJobEntity suspendedJob : list) {
            suspendedJob.delete();
        }
        DeadLetterJobEntityManager deadLetterJobEntityManager = Context.getCommandContext().getDeadLetterJobEntityManager();
        List<DeadLetterJobEntity> deadLetterJobs = deadLetterJobEntityManager.findDeadLetterJobsByExecutionId(this.id);
        for (DeadLetterJobEntity deadLetterJob : deadLetterJobs) {
            deadLetterJob.delete();
        }
    }

    private void removeTasks(String reason) {
        if (reason == null) {
            reason = "deleted";
        }
        for (TaskEntity task : this.getTasks()) {
            if (this.replacedBy != null) {
                if (task.getExecution() != null && task.getExecution() == this.replacedBy) continue;
                task.setExecution(this.replacedBy);
                this.replacedBy.addTask(task);
                continue;
            }
            Context.getCommandContext().getTaskEntityManager().deleteTask(task, reason, false);
        }
    }

    @Override
    public ExecutionEntity getReplacedBy() {
        return this.replacedBy;
    }

    @Override
    public void setReplacedBy(InterpretableExecution replacedBy) {
        this.replacedBy = (ExecutionEntity)replacedBy;
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        ArrayList<TaskEntity> allTasks = new ArrayList<TaskEntity>();
        allTasks.addAll(this.getTasks());
        List<TaskEntity> cachedTasks = dbSqlSession.findInCache(TaskEntity.class);
        for (TaskEntity taskEntity : cachedTasks) {
            if (!taskEntity.getExecutionId().equals(this.getId())) continue;
            allTasks.add(taskEntity);
        }
        for (TaskEntity taskEntity : allTasks) {
            taskEntity.setExecutionId(replacedBy.getId());
            taskEntity.setExecution(this.replacedBy);
            List<VariableInstanceEntity> list = commandContext.getVariableInstanceEntityManager().findVariableInstancesByTaskId(taskEntity.getId());
            for (VariableInstanceEntity variable : list) {
                variable.setExecution(this.replacedBy);
            }
            this.replacedBy.addTask(taskEntity);
        }
        this.tasks.clear();
        this.tasks = dbSqlSession.findInCache(TaskEntity.class);
        for (TaskEntity taskEntity : this.tasks) {
            if (!this.id.equals(taskEntity.getExecutionId())) continue;
            taskEntity.setExecutionId(replacedBy.getId());
        }
        List<JobEntity> jobs = this.getJobs();
        for (JobEntity jobEntity : jobs) {
            jobEntity.setExecution((ExecutionEntity)replacedBy);
        }
        List<TimerJobEntity> list = this.getTimerJobs();
        for (TimerJobEntity timerJobEntity : list) {
            timerJobEntity.setExecution((ExecutionEntity)replacedBy);
        }
        List<EventSubscriptionEntity> list2 = this.getEventSubscriptions();
        for (EventSubscriptionEntity subscriptionEntity : list2) {
            subscriptionEntity.setExecution((ExecutionEntity)replacedBy);
        }
        List<VariableInstanceEntity> list3 = commandContext.getVariableInstanceEntityManager().findVariableInstancesByExecutionId(this.id);
        for (VariableInstanceEntity variable : list3) {
            variable.setExecutionId(replacedBy.getId());
        }
        List<VariableInstanceEntity> list4 = dbSqlSession.findInCache(VariableInstanceEntity.class);
        for (VariableInstanceEntity variable : list4) {
            if (!this.id.equals(variable.getExecutionId())) continue;
            variable.setExecutionId(replacedBy.getId());
        }
        commandContext.getHistoryManager().recordExecutionReplacedBy(this, replacedBy);
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setProcessInstanceId(this.processInstanceId);
        variableInstance.setExecutionId(this.id);
    }

    @Override
    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceEntityManager().findVariableInstancesByExecutionId(this.id);
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        return this.getParent();
    }

    @Override
    protected ExecutionEntity getSourceActivityExecution() {
        return this.activityId != null ? this : null;
    }

    @Override
    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableInstanceEntity result = super.createVariableInstance(variableName, value, sourceActivityExecution);
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createVariableEvent(FlowableEngineEventType.VARIABLE_CREATED, variableName, value, result.getType(), result.getTaskId(), result.getExecutionId(), this.getProcessInstanceId(), this.getProcessDefinitionId()));
        }
        return result;
    }

    @Override
    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        super.updateVariableInstance(variableInstance, value, sourceActivityExecution);
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createVariableEvent(FlowableEngineEventType.VARIABLE_UPDATED, variableInstance.getName(), value, variableInstance.getType(), variableInstance.getTaskId(), variableInstance.getExecutionId(), this.getProcessInstanceId(), this.getProcessDefinitionId()));
        }
    }

    @Override
    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new ActivitiException("lazy loading outside command context");
        }
        VariableInstanceEntity variableInstance = commandContext.getVariableInstanceEntityManager().findVariableInstanceByExecutionAndName(this.id, variableName);
        return variableInstance;
    }

    @Override
    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new ActivitiException("lazy loading outside command context");
        }
        return commandContext.getVariableInstanceEntityManager().findVariableInstancesByExecutionAndNames(this.id, variableNames);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("isActive", this.isActive);
        persistentState.put("isConcurrent", this.isConcurrent);
        persistentState.put("isScope", this.isScope);
        persistentState.put("isEventScope", this.isEventScope);
        persistentState.put("parentId", this.parentId);
        persistentState.put("name", this.name);
        persistentState.put("lockTime", this.lockTime);
        persistentState.put("superExecution", this.superExecutionId);
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("cachedEntityState", this.cachedEntityState);
        return persistentState;
    }

    public FlowElement getCurrentFlowElement() {
        String processDefinitionId;
        if (this.currentFlowElement == null && (processDefinitionId = this.getProcessDefinitionId()) != null) {
            Process process = ProcessDefinitionUtil.getProcess((String)processDefinitionId);
            this.currentFlowElement = process.getFlowElement(this.getCurrentActivityId(), true);
        }
        return this.currentFlowElement;
    }

    public void setCurrentFlowElement(FlowElement currentFlowElement) {
        this.currentFlowElement = currentFlowElement;
        this.activityId = currentFlowElement != null ? currentFlowElement.getId() : null;
    }

    public FlowableListener getCurrentFlowableListener() {
        throw new UnsupportedOperationException();
    }

    public void setCurrentFlowableListener(FlowableListener currentListener) {
        throw new UnsupportedOperationException();
    }

    public void insert() {
        Context.getCommandContext().getDbSqlSession().insert(this);
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(AtomicOperation.DELETE_CASCADE);
    }

    public void setDeleteRoot(boolean deleteRoot) {
        this.deleteRoot = deleteRoot;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    public String toString() {
        if (this.isProcessInstanceType()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isConcurrent ? "Concurrent" : "") + (this.isScope ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }

    public List<EventSubscriptionEntity> getEventSubscriptionsInternal() {
        this.ensureEventSubscriptionsInitialized();
        return this.eventSubscriptions;
    }

    public List<EventSubscriptionEntity> getEventSubscriptions() {
        return new ArrayList<EventSubscriptionEntity>(this.getEventSubscriptionsInternal());
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions() {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptionsInternal();
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>(eventSubscriptions.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity)) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions(String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptionsInternal();
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>(eventSubscriptions.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) || !activityId.equals(eventSubscriptionEntity.getActivityId())) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    protected void ensureEventSubscriptionsInitialized() {
        if (this.eventSubscriptions == null || this.eventSubscriptions.isEmpty()) {
            this.eventSubscriptions = Context.getCommandContext().getEventSubscriptionEntityManager().findEventSubscriptionsByExecution(this.id);
        }
    }

    public void addEventSubscription(EventSubscriptionEntity eventSubscriptionEntity) {
        this.getEventSubscriptionsInternal().add(eventSubscriptionEntity);
    }

    public void removeEventSubscription(EventSubscriptionEntity eventSubscriptionEntity) {
        this.getEventSubscriptionsInternal().remove(eventSubscriptionEntity);
    }

    protected void ensureJobsInitialized() {
        if (this.jobs == null) {
            this.jobs = Context.getCommandContext().getJobEntityManager().findJobsByExecutionId(this.id);
        }
    }

    protected List<JobEntity> getJobsInternal() {
        this.ensureJobsInitialized();
        return this.jobs;
    }

    public List<JobEntity> getJobs() {
        return new ArrayList<JobEntity>(this.getJobsInternal());
    }

    public void addJob(JobEntity jobEntity) {
        this.getJobsInternal().add(jobEntity);
    }

    public void removeJob(JobEntity job) {
        this.getJobsInternal().remove(job);
    }

    protected void ensureTimerJobsInitialized() {
        if (this.timerJobs == null) {
            this.timerJobs = Context.getCommandContext().getTimerJobEntityManager().findTimerJobsByExecutionId(this.id);
        }
    }

    protected List<TimerJobEntity> getTimerJobsInternal() {
        this.ensureTimerJobsInitialized();
        return this.timerJobs;
    }

    public List<TimerJobEntity> getTimerJobs() {
        return new ArrayList<TimerJobEntity>(this.getTimerJobsInternal());
    }

    public void addTimerJob(TimerJobEntity jobEntity) {
        this.getTimerJobsInternal().add(jobEntity);
    }

    public void removeTimerJob(TimerJobEntity job) {
        this.getTimerJobsInternal().remove(job);
    }

    protected void ensureTasksInitialized() {
        if (this.tasks == null) {
            this.tasks = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.id);
        }
    }

    protected List<TaskEntity> getTasksInternal() {
        this.ensureTasksInitialized();
        return this.tasks;
    }

    public List<TaskEntity> getTasks() {
        return new ArrayList<TaskEntity>(this.getTasksInternal());
    }

    public void addTask(TaskEntity taskEntity) {
        this.getTasksInternal().add(taskEntity);
    }

    public void removeTask(TaskEntity task) {
        this.getTasksInternal().remove(task);
    }

    public List<IdentityLinkEntity> getIdentityLinks() {
        if (this.identityLinks == null) {
            this.identityLinks = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinksByProcessInstanceId(this.id);
        }
        return this.identityLinks;
    }

    public IdentityLinkEntity addIdentityLink(String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        this.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessInstance(this);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        identityLinkEntity.insert();
        return identityLinkEntity;
    }

    public IdentityLinkEntity involveUser(String userId, String type) {
        for (IdentityLinkEntity identityLink : this.getIdentityLinks()) {
            if (!identityLink.isUser() || !identityLink.getUserId().equals(userId)) continue;
            return identityLink;
        }
        return this.addIdentityLink(userId, null, type);
    }

    public void removeIdentityLinks() {
        Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLinksByProcInstance(this.id);
    }

    public void setCachedEntityState(int cachedEntityState) {
        this.cachedEntityState = cachedEntityState;
    }

    public int getCachedEntityState() {
        return this.cachedEntityState;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getRootProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    @Override
    public void setTransition(TransitionImpl transition) {
        this.transition = transition;
        if (this.replacedBy != null) {
            this.replacedBy.setTransition(transition);
        }
    }

    public TransitionImpl getTransitionBeingTaken() {
        return this.transitionBeingTaken;
    }

    public void setTransitionBeingTaken(TransitionImpl transitionBeingTaken) {
        this.transitionBeingTaken = transitionBeingTaken;
        if (this.replacedBy != null) {
            this.replacedBy.setTransitionBeingTaken(transitionBeingTaken);
        }
    }

    @Override
    public Integer getExecutionListenerIndex() {
        return this.executionListenerIndex;
    }

    @Override
    public void setExecutionListenerIndex(Integer executionListenerIndex) {
        this.executionListenerIndex = executionListenerIndex;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public void setEnded(boolean ended) {
        this.isEnded = ended;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public PvmProcessElement getEventSource() {
        return this.eventSource;
    }

    @Override
    public void setEventSource(PvmProcessElement eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public boolean isEventScope() {
        return this.isEventScope;
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    @Override
    public StartingExecution getStartingExecution() {
        return this.startingExecution;
    }

    @Override
    public void disposeStartingExecution() {
        this.startingExecution = null;
    }

    public String getCurrentActivityId() {
        return this.activityId;
    }

    public String getCurrentActivityName() {
        return this.activityName;
    }

    @Override
    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    @Override
    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Date getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(Date lockTime) {
        this.lockTime = lockTime;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public List<VariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new VariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    public String updateProcessBusinessKey(String bzKey) {
        if (this.isProcessInstanceType() && bzKey != null) {
            this.setBusinessKey(bzKey);
            Context.getCommandContext().getHistoryManager().updateProcessBusinessKeyInHistory(this);
            if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, this));
            }
            return bzKey;
        }
        return null;
    }

    public void deleteIdentityLink(String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinkByProcessInstanceUserGroupAndType(this.id, userId, groupId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(identityLink, true);
        }
        this.getIdentityLinks().removeAll(identityLinks);
    }

    public boolean isMultiInstanceRoot() {
        return false;
    }

    public void setMultiInstanceRoot(boolean isMultiInstanceRoot) {
    }
}

