/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricFormProperty;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.impl.TablePageQueryImpl;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailAssignmentEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailTransitionInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.activiti.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.activiti.engine.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.PropertyEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.management.TableMetaData;
import org.activiti.engine.management.TablePage;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.ibatis.session.RowBounds;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDataManager
extends AbstractManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDataManager.class);
    public static Map<Class<?>, String> apiTypeToTableNameMap = new HashMap();
    public static Map<Class<? extends PersistentObject>, String> persistentObjectToTableNameMap = new HashMap<Class<? extends PersistentObject>, String>();

    public Map<String, Long> getTableCount() {
        HashMap<String, Long> tableCount = new HashMap<String, Long>();
        try {
            for (String tableName : this.getTablesPresentInDatabase()) {
                tableCount.put(tableName, this.getTableCount(tableName));
            }
            LOGGER.debug("Number of rows per activiti table: {}", tableCount);
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't get table counts", e);
        }
        return tableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTablesPresentInDatabase() {
        ArrayList<String> tableNames = new ArrayList<String>();
        Connection connection = null;
        try {
            connection = this.getDbSqlSession().getSqlSession().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet tables = null;){
                LOGGER.debug("retrieving activiti tables from jdbc metadata");
                String databaseTablePrefix = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
                String tableNameFilter = databaseTablePrefix + "ACT_%";
                if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                    tableNameFilter = databaseTablePrefix + "act_%";
                }
                if ("oracle".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                    tableNameFilter = databaseTablePrefix + "ACT" + databaseMetaData.getSearchStringEscape() + "_%";
                }
                String catalog = null;
                if (this.getProcessEngineConfiguration().getDatabaseCatalog() != null && this.getProcessEngineConfiguration().getDatabaseCatalog().length() > 0) {
                    catalog = this.getProcessEngineConfiguration().getDatabaseCatalog();
                }
                String schema = null;
                if (this.getProcessEngineConfiguration().getDatabaseSchema() != null && this.getProcessEngineConfiguration().getDatabaseSchema().length() > 0) {
                    schema = this.getProcessEngineConfiguration().getDatabaseSchema();
                }
                this.getDbSqlSession();
                tables = databaseMetaData.getTables(catalog, schema, tableNameFilter, DbSqlSession.JDBC_METADATA_TABLE_TYPES);
                while (tables.next()) {
                    String tableName = tables.getString("TABLE_NAME");
                    tableName = tableName.toUpperCase();
                    tableNames.add(tableName);
                    LOGGER.debug("  retrieved activiti table name {}", (Object)tableName);
                }
            }
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't get activiti table names using metadata: " + e.getMessage(), e);
        }
        return tableNames;
    }

    protected long getTableCount(String tableName) {
        LOGGER.debug("selecting table count for {}", (Object)tableName);
        Long count = (Long)this.getDbSqlSession().selectOne("selectTableCount", Collections.singletonMap("tableName", tableName));
        return count;
    }

    public TablePage getTablePage(TablePageQueryImpl tablePageQuery, int firstResult, int maxResults) {
        TablePage tablePage = new TablePage();
        List tableData = this.getDbSqlSession().getSqlSession().selectList("selectTableData", (Object)tablePageQuery, new RowBounds(firstResult, maxResults));
        tablePage.setTableName(tablePageQuery.getTableName());
        tablePage.setTotal(this.getTableCount(tablePageQuery.getTableName()));
        tablePage.setRows(tableData);
        tablePage.setFirstResult(firstResult);
        return tablePage;
    }

    public String getTableName(Class<?> entityClass, boolean withPrefix) {
        String databaseTablePrefix = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix();
        String tableName = null;
        tableName = PersistentObject.class.isAssignableFrom(entityClass) ? persistentObjectToTableNameMap.get(entityClass) : apiTypeToTableNameMap.get(entityClass);
        if (withPrefix) {
            return databaseTablePrefix + tableName;
        }
        return tableName;
    }

    public TableMetaData getTableMetaData(String tableName) {
        TableMetaData result = new TableMetaData();
        try {
            result.setTableName(tableName);
            DatabaseMetaData metaData = this.getDbSqlSession().getSqlSession().getConnection().getMetaData();
            if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                tableName = tableName.toLowerCase();
            }
            String catalog = null;
            if (this.getProcessEngineConfiguration().getDatabaseCatalog() != null && this.getProcessEngineConfiguration().getDatabaseCatalog().length() > 0) {
                catalog = this.getProcessEngineConfiguration().getDatabaseCatalog();
            }
            String schema = null;
            if (this.getProcessEngineConfiguration().getDatabaseSchema() != null && this.getProcessEngineConfiguration().getDatabaseSchema().length() > 0) {
                schema = this.getProcessEngineConfiguration().getDatabaseSchema();
            }
            ResultSet resultSet = metaData.getColumns(catalog, schema, tableName, null);
            while (resultSet.next()) {
                boolean wrongSchema = false;
                if (schema != null && schema.length() > 0) {
                    for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                        String columnName = resultSet.getMetaData().getColumnName(i + 1);
                        if (!"TABLE_SCHEM".equalsIgnoreCase(columnName) && !"TABLE_SCHEMA".equalsIgnoreCase(columnName)) continue;
                        if (schema.equalsIgnoreCase(resultSet.getString(resultSet.getMetaData().getColumnName(i + 1)))) break;
                        wrongSchema = true;
                        break;
                    }
                }
                if (wrongSchema) continue;
                String name = resultSet.getString("COLUMN_NAME").toUpperCase();
                String type = resultSet.getString("TYPE_NAME").toUpperCase();
                result.addColumnMetaData(name, type);
            }
        }
        catch (SQLException e) {
            throw new ActivitiException("Could not retrieve database metadata: " + e.getMessage());
        }
        if (result.getColumnNames().isEmpty()) {
            result = null;
        }
        return result;
    }

    static {
        persistentObjectToTableNameMap.put(TaskEntity.class, "ACT_RU_TASK");
        persistentObjectToTableNameMap.put(ExecutionEntity.class, "ACT_RU_EXECUTION");
        persistentObjectToTableNameMap.put(IdentityLinkEntity.class, "ACT_RU_IDENTITYLINK");
        persistentObjectToTableNameMap.put(VariableInstanceEntity.class, "ACT_RU_VARIABLE");
        persistentObjectToTableNameMap.put(JobEntity.class, "ACT_RU_JOB");
        persistentObjectToTableNameMap.put(TimerJobEntity.class, "ACT_RU_TIMER_JOB");
        persistentObjectToTableNameMap.put(EventSubscriptionEntity.class, "ACT_RU_EVENT_SUBSCR");
        persistentObjectToTableNameMap.put(CompensateEventSubscriptionEntity.class, "ACT_RU_EVENT_SUBSCR");
        persistentObjectToTableNameMap.put(MessageEventSubscriptionEntity.class, "ACT_RU_EVENT_SUBSCR");
        persistentObjectToTableNameMap.put(SignalEventSubscriptionEntity.class, "ACT_RU_EVENT_SUBSCR");
        persistentObjectToTableNameMap.put(DeploymentEntity.class, "ACT_RE_DEPLOYMENT");
        persistentObjectToTableNameMap.put(ProcessDefinitionEntity.class, "ACT_RE_PROCDEF");
        persistentObjectToTableNameMap.put(ModelEntity.class, "ACT_RE_MODEL");
        persistentObjectToTableNameMap.put(CommentEntity.class, "ACT_HI_COMMENT");
        persistentObjectToTableNameMap.put(HistoricActivityInstanceEntity.class, "ACT_HI_ACTINST");
        persistentObjectToTableNameMap.put(AttachmentEntity.class, "ACT_HI_ATTACHMEN");
        persistentObjectToTableNameMap.put(HistoricProcessInstanceEntity.class, "ACT_HI_PROCINST");
        persistentObjectToTableNameMap.put(HistoricVariableInstanceEntity.class, "ACT_HI_VARINST");
        persistentObjectToTableNameMap.put(HistoricTaskInstanceEntity.class, "ACT_HI_TASKINST");
        persistentObjectToTableNameMap.put(HistoricIdentityLinkEntity.class, "ACT_HI_IDENTITYLINK");
        persistentObjectToTableNameMap.put(HistoricDetailAssignmentEntity.class, "ACT_HI_DETAIL");
        persistentObjectToTableNameMap.put(HistoricDetailTransitionInstanceEntity.class, "ACT_HI_DETAIL");
        persistentObjectToTableNameMap.put(HistoricFormPropertyEntity.class, "ACT_HI_DETAIL");
        persistentObjectToTableNameMap.put(HistoricDetailVariableInstanceUpdateEntity.class, "ACT_HI_DETAIL");
        persistentObjectToTableNameMap.put(HistoricDetailEntity.class, "ACT_HI_DETAIL");
        persistentObjectToTableNameMap.put(PropertyEntity.class, "ACT_GE_PROPERTY");
        persistentObjectToTableNameMap.put(ByteArrayEntity.class, "ACT_GE_BYTEARRAY");
        persistentObjectToTableNameMap.put(ResourceEntity.class, "ACT_GE_BYTEARRAY");
        apiTypeToTableNameMap.put(Task.class, "ACT_RU_TASK");
        apiTypeToTableNameMap.put(Execution.class, "ACT_RU_EXECUTION");
        apiTypeToTableNameMap.put(ProcessInstance.class, "ACT_RU_EXECUTION");
        apiTypeToTableNameMap.put(ProcessDefinition.class, "ACT_RE_PROCDEF");
        apiTypeToTableNameMap.put(Deployment.class, "ACT_RE_DEPLOYMENT");
        apiTypeToTableNameMap.put(Job.class, "ACT_RU_JOB");
        apiTypeToTableNameMap.put(Model.class, "ACT_RE_MODEL");
        apiTypeToTableNameMap.put(HistoricProcessInstance.class, "ACT_HI_PROCINST");
        apiTypeToTableNameMap.put(HistoricActivityInstance.class, "ACT_HI_ACTINST");
        apiTypeToTableNameMap.put(HistoricDetail.class, "ACT_HI_DETAIL");
        apiTypeToTableNameMap.put(HistoricVariableUpdate.class, "ACT_HI_DETAIL");
        apiTypeToTableNameMap.put(HistoricFormProperty.class, "ACT_HI_DETAIL");
        apiTypeToTableNameMap.put(HistoricTaskInstance.class, "ACT_HI_TASKINST");
        apiTypeToTableNameMap.put(HistoricVariableInstance.class, "ACT_HI_VARINST");
    }
}

