/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.FlowableEngineEventType;

public class TaskEntityManager
extends AbstractManager {
    public void deleteTasksByProcessInstanceId(String processInstanceId, String deleteReason, boolean cascade) {
        List tasks = this.getDbSqlSession().createTaskQuery().processInstanceId(processInstanceId).list();
        String reason = deleteReason == null || deleteReason.length() == 0 ? "deleted" : deleteReason;
        CommandContext commandContext = Context.getCommandContext();
        for (TaskEntity task : tasks) {
            if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createActivityCancelledEvent(task.getExecution().getActivityId(), task.getName(), task.getExecutionId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), "userTask", UserTaskActivityBehavior.class.getName(), deleteReason));
            }
            this.deleteTask(task, reason, cascade);
        }
    }

    public void deleteTask(TaskEntity task, String deleteReason, boolean cascade) {
        if (!task.isDeleted()) {
            task.fireEvent("delete");
            task.setDeleted(true);
            CommandContext commandContext = Context.getCommandContext();
            String taskId = task.getId();
            List<Task> subTasks = this.findTasksByParentTaskId(taskId);
            for (Task subTask : subTasks) {
                this.deleteTask((TaskEntity)subTask, deleteReason, cascade);
            }
            commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByTaskId(taskId);
            commandContext.getVariableInstanceEntityManager().deleteVariableInstanceByTask(task);
            if (cascade) {
                commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstanceById(taskId);
            } else {
                commandContext.getHistoryManager().recordTaskEnd(taskId, deleteReason);
            }
            this.getDbSqlSession().delete(task);
            if (commandContext.getEventDispatcher().isEnabled()) {
                commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, task));
            }
        }
    }

    public TaskEntity findTaskById(String id) {
        if (id == null) {
            throw new ActivitiIllegalArgumentException("Invalid task id : null");
        }
        return this.getDbSqlSession().selectById(TaskEntity.class, id);
    }

    public List<TaskEntity> findTasksByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectTasksByExecutionId", executionId);
    }

    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectTasksByProcessInstanceId", processInstanceId);
    }

    @Deprecated
    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery, Page page) {
        taskQuery.setFirstResult(page.getFirstResult());
        taskQuery.setMaxResults(page.getMaxResults());
        return this.findTasksByQueryCriteria(taskQuery);
    }

    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery) {
        String query = "selectTaskByQueryCriteria";
        return this.getDbSqlSession().selectList("selectTaskByQueryCriteria", taskQuery);
    }

    public List<Task> findTasksAndVariablesByQueryCriteria(TaskQueryImpl taskQuery) {
        String query = "selectTaskWithVariablesByQueryCriteria";
        if (taskQuery.getFirstResult() < 0 || taskQuery.getMaxResults() <= 0) {
            return Collections.EMPTY_LIST;
        }
        int firstResult = taskQuery.getFirstResult();
        int maxResults = taskQuery.getMaxResults();
        if (taskQuery.getTaskVariablesLimit() != null) {
            taskQuery.setMaxResults(taskQuery.getTaskVariablesLimit());
        } else {
            taskQuery.setMaxResults(Context.getProcessEngineConfiguration().getTaskQueryLimit());
        }
        taskQuery.setFirstResult(0);
        List instanceList = this.getDbSqlSession().selectListWithRawParameterWithoutFilter("selectTaskWithVariablesByQueryCriteria", taskQuery, taskQuery.getFirstResult(), taskQuery.getMaxResults());
        if (instanceList != null && !instanceList.isEmpty()) {
            if (firstResult > 0) {
                if (firstResult <= instanceList.size()) {
                    int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                    return instanceList.subList(firstResult, toIndex);
                }
                return Collections.EMPTY_LIST;
            }
            int toIndex = Math.min(maxResults, instanceList.size());
            return instanceList.subList(0, toIndex);
        }
        return Collections.EMPTY_LIST;
    }

    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByQueryCriteria", taskQuery);
    }

    public List<Task> findTasksByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectTaskByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findTaskCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByNativeQuery", parameterMap);
    }

    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.getDbSqlSession().selectList("selectTasksByParentTaskId", parentTaskId);
    }

    public void deleteTask(String taskId, String deleteReason, boolean cascade) {
        TaskEntity task = Context.getCommandContext().getTaskEntityManager().findTaskById(taskId);
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new ActivitiException("The task cannot be deleted because is part of a running process");
            }
            String reason = deleteReason == null || deleteReason.length() == 0 ? "deleted" : deleteReason;
            this.deleteTask(task, reason, cascade);
        } else if (cascade) {
            Context.getCommandContext().getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstanceById(taskId);
        }
    }

    public void updateTaskTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateTaskTenantIdForDeployment", params);
    }
}

