/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import org.activiti.engine.ActivitiActivityExecutionException;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.PvmException;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.logging.LogMDC;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicOperationActivityExecute
implements AtomicOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicOperationActivityExecute.class);

    @Override
    public boolean isAsync(InterpretableExecution execution) {
        return false;
    }

    @Override
    public void execute(InterpretableExecution execution) {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        if (activityBehavior == null) {
            throw new PvmException("no behavior specified in " + activity);
        }
        LOGGER.debug("{} executes {}: {}", new Object[]{execution, activity, activityBehavior.getClass().getName()});
        try {
            if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_STARTED, execution.getActivity().getId(), (String)execution.getActivity().getProperty("name"), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (String)activity.getProperties().get("type"), activity.getActivityBehavior().getClass().getCanonicalName()));
            }
            activityBehavior.execute((DelegateExecution)execution);
        }
        catch (ActivitiException e) {
            throw e;
        }
        catch (Throwable t) {
            LogMDC.putMDCExecution(execution);
            throw new ActivitiActivityExecutionException("couldn't execute activity <" + activity.getProperty("type") + " id=\"" + activity.getId() + "\" ...>: " + t.getMessage(), t);
        }
    }
}

