/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutgoingExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutgoingExecution.class);
    protected InterpretableExecution outgoingExecution;
    protected PvmTransition outgoingTransition;
    protected boolean isNew;

    public OutgoingExecution(InterpretableExecution outgoingExecution, PvmTransition outgoingTransition, boolean isNew) {
        this.outgoingExecution = outgoingExecution;
        this.outgoingTransition = outgoingTransition;
        this.isNew = isNew;
    }

    public void take() {
        this.take(true);
    }

    public void take(boolean fireActivityCompletedEvent) {
        if (this.outgoingExecution.getReplacedBy() != null) {
            this.outgoingExecution = this.outgoingExecution.getReplacedBy();
        }
        if (!this.outgoingExecution.isDeleteRoot()) {
            this.outgoingExecution.take(this.outgoingTransition, fireActivityCompletedEvent);
        } else {
            LOGGER.debug("Not taking transition '{}', outgoing execution has ended.", (Object)this.outgoingTransition);
        }
    }
}

