/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.scripting;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.scripting.ScriptingEngines;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.VariableScope;

public class ScriptCondition
implements Condition {
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final String language;

    public ScriptCondition(String expression, String language) {
        this.expression = expression;
        this.language = language;
    }

    @Override
    public boolean evaluate(String sequenceFlowId, DelegateExecution execution) {
        String conditionExpression = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode elementProperties = Context.getBpmnOverrideElementProperties(sequenceFlowId, execution.getProcessDefinitionId());
            conditionExpression = this.getActiveValue(this.expression, "sequenceFlowCondition", elementProperties);
        } else {
            conditionExpression = this.expression;
        }
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        Object result = scriptingEngines.evaluate(conditionExpression, this.language, (VariableScope)execution);
        if (result == null) {
            throw new ActivitiException("condition script returns null: " + this.expression);
        }
        if (!(result instanceof Boolean)) {
            throw new ActivitiException("condition script returns non-Boolean: " + result + " (" + result.getClass().getName() + ")");
        }
        return (Boolean)result;
    }

    protected String getActiveValue(String originalValue, String propertyName, ObjectNode elementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (elementProperties != null && (overrideValueNode = elementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }
}

