/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.scripting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.scripting.ScriptBindingsFactory;
import org.flowable.engine.delegate.VariableScope;

public class ScriptingEngines {
    public static final String DEFAULT_SCRIPTING_LANGUAGE = "juel";
    public static final String GROOVY_SCRIPTING_LANGUAGE = "groovy";
    private final ScriptEngineManager scriptEngineManager;
    protected ScriptBindingsFactory scriptBindingsFactory;
    protected boolean cacheScriptingEngines = true;
    protected Map<String, ScriptEngine> cachedEngines;

    public ScriptingEngines(ScriptBindingsFactory scriptBindingsFactory) {
        this(new ScriptEngineManager());
        this.scriptBindingsFactory = scriptBindingsFactory;
    }

    public ScriptingEngines(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
        this.cachedEngines = new HashMap<String, ScriptEngine>();
    }

    public ScriptingEngines addScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
        return this;
    }

    public void setScriptEngineFactories(List<ScriptEngineFactory> scriptEngineFactories) {
        if (scriptEngineFactories != null) {
            for (ScriptEngineFactory scriptEngineFactory : scriptEngineFactories) {
                this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
            }
        }
    }

    public Object evaluate(String script, String language, VariableScope variableScope) {
        return this.evaluate(script, language, this.createBindings(variableScope));
    }

    public Object evaluate(String script, String language, VariableScope variableScope, boolean storeScriptVariables) {
        return this.evaluate(script, language, this.createBindings(variableScope, storeScriptVariables));
    }

    public void setCacheScriptingEngines(boolean cacheScriptingEngines) {
        this.cacheScriptingEngines = cacheScriptingEngines;
    }

    public boolean isCacheScriptingEngines() {
        return this.cacheScriptingEngines;
    }

    protected Object evaluate(String script, String language, Bindings bindings) {
        ScriptEngine scriptEngine = this.getEngineByName(language);
        try {
            return scriptEngine.eval(script, bindings);
        }
        catch (ScriptException e) {
            throw new ActivitiException("problem evaluating script: " + e.getMessage(), e);
        }
    }

    protected ScriptEngine getEngineByName(String language) {
        ScriptEngine scriptEngine = null;
        if (this.cacheScriptingEngines) {
            scriptEngine = this.cachedEngines.get(language);
            if (scriptEngine == null && (scriptEngine = this.scriptEngineManager.getEngineByName(language)) != null) {
                Object threadingParameter;
                if (GROOVY_SCRIPTING_LANGUAGE.equals(language)) {
                    try {
                        scriptEngine.getContext().setAttribute("#jsr223.groovy.engine.keep.globals", "weak", 100);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((threadingParameter = scriptEngine.getFactory().getParameter("THREADING")) != null) {
                    this.cachedEngines.put(language, scriptEngine);
                }
            }
        } else {
            scriptEngine = this.scriptEngineManager.getEngineByName(language);
        }
        if (scriptEngine == null) {
            throw new ActivitiException("Can't find scripting engine for '" + language + "'");
        }
        return scriptEngine;
    }

    protected Bindings createBindings(VariableScope variableScope) {
        return this.scriptBindingsFactory.createBindings(variableScope);
    }

    protected Bindings createBindings(VariableScope variableScope, boolean storeScriptVariables) {
        return this.scriptBindingsFactory.createBindings(variableScope, storeScriptVariables);
    }

    public ScriptBindingsFactory getScriptBindingsFactory() {
        return this.scriptBindingsFactory;
    }

    public void setScriptBindingsFactory(ScriptBindingsFactory scriptBindingsFactory) {
        this.scriptBindingsFactory = scriptBindingsFactory;
    }
}

