/*
 *
 *  Copyright 2022 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.flowstep.http;

import org.flowstep.core.connection.ConnectionBuilder;
import org.flowstep.core.connection.EnvironmentConnection;
import org.flowstep.core.model.environment.EnvironmentItemSettings;
import org.flowstep.http.model.HttpEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpConnectionBuilder implements ConnectionBuilder {

    private RestTemplate restTemplate;

    @Autowired
    public HttpConnectionBuilder setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        return this;
    }

    @Override
    public boolean canBuildConnection(EnvironmentItemSettings settings) {
        return settings instanceof HttpEnvironment;
    }

    @Override
    public EnvironmentConnection buildConnection(EnvironmentItemSettings settings) {
        return new EnvironmentConnection(restTemplate, settings);
    }
}
