package org.fluentlenium.core.conditions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import org.fluentlenium.core.domain.FluentWebElement;

import java.util.regex.Pattern;

/**
 * Conditions implement for string lists of elements.
 */
public class StringListConditionsImpl extends BaseObjectListConditions<String, StringConditions> implements StringConditions {
    public StringListConditionsImpl(final Conditions<FluentWebElement> listConditions,
            final Function<FluentWebElement, String> stringGetter,
            final Function<FluentWebElement, StringConditions> conditionsGetter) {
        super(listConditions, stringGetter, conditionsGetter);
    }

    @Override
    public StringListConditionsImpl not() {
        return new StringListConditionsImpl(this.conditions.not(), objectGetter, conditionsGetter);
    }

    @Override
    public boolean contains(final CharSequence s) {
        return this.conditions.verify(new Predicate<FluentWebElement>() {
            @Override
            public boolean apply(final FluentWebElement input) {
                return conditionsGetter.apply(input).contains(s);
            }
        });
    }

    @Override
    public boolean startsWith(final String prefix) {
        return this.conditions.verify(new Predicate<FluentWebElement>() {
            @Override
            public boolean apply(final FluentWebElement input) {
                return conditionsGetter.apply(input).startsWith(prefix);
            }
        });
    }

    @Override
    public boolean endsWith(final String suffix) {
        return this.conditions.verify(new Predicate<FluentWebElement>() {
            @Override
            public boolean apply(final FluentWebElement input) {
                return conditionsGetter.apply(input).endsWith(suffix);
            }
        });
    }

    @Override
    public boolean equalTo(final String anotherString) {
        return this.conditions.verify(new Predicate<FluentWebElement>() {
            @Override
            public boolean apply(final FluentWebElement input) {
                return conditionsGetter.apply(input).equalTo(anotherString);
            }
        });
    }

    @Override
    public boolean equalToIgnoreCase(final String anotherString) {
        return this.conditions.verify(new Predicate<FluentWebElement>() {
            @Override
            public boolean apply(final FluentWebElement input) {
                return conditionsGetter.apply(input).equalToIgnoreCase(anotherString);
            }
        });
    }

    @Override
    public boolean matches(final String regex) {
        return this.conditions.verify(new Predicate<FluentWebElement>() {
            @Override
            public boolean apply(final FluentWebElement input) {
                return conditionsGetter.apply(input).matches(regex);
            }
        });
    }

    @Override
    public boolean matches(final Pattern pattern) {
        return this.conditions.verify(new Predicate<FluentWebElement>() {
            @Override
            public boolean apply(final FluentWebElement input) {
                return conditionsGetter.apply(input).matches(pattern);
            }
        });
    }
}
