package org.fluentlenium.core.hook.wait;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.hook.BaseFluentHook;
import org.fluentlenium.core.wait.FluentWait;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

import java.util.List;

public class WaitHook extends BaseFluentHook<WaitHookOptions> {
    public WaitHook(final FluentControl fluentControl, final ComponentInstantiator instantiator,
            final Supplier<WebElement> elementSupplier, final Supplier<ElementLocator> locatorSupplier,
            final Supplier<String> toStringSupplier, final WaitHookOptions options) {
        super(fluentControl, instantiator, elementSupplier, locatorSupplier, toStringSupplier, options);
    }

    @Override
    protected WaitHookOptions newOptions() {
        return new WaitHookOptions();
    }

    public FluentWait buildAwait() {
        return getOptions().configureAwait(await());
    }

    @Override
    public void click() {
        buildAwait().until(getFluentWebElement()).clickable();
        super.click();
    }

    @Override
    public void sendKeys(final CharSequence... keysToSend) {
        buildAwait().until(getFluentWebElement()).enabled();
        super.sendKeys(keysToSend);
    }

    @Override
    public void submit() {
        buildAwait().until(getFluentWebElement()).enabled();
        super.submit();
    }

    @Override
    public void clear() {
        buildAwait().until(getFluentWebElement()).enabled();
        super.clear();
    }

    @Override
    public List<WebElement> findElements() {
        return buildAwait().ignoring(NoSuchElementException.class).until(new Function<FluentControl, List<WebElement>>() {
            @Override
            public List<WebElement> apply(final FluentControl input) {
                final List<WebElement> elements = WaitHook.super.findElements();
                if (elements.size() == 0) {
                    return null;
                }
                return elements;
            }

            @Override
            public String toString() {
                return WaitHook.super.toString();
            }
        });
    }

    @Override
    public WebElement findElement() {
        return buildAwait().ignoring(NoSuchElementException.class).until(new Function<FluentControl, WebElement>() {
            @Override
            public WebElement apply(final FluentControl input) {
                return WaitHook.super.findElement();
            }

            @Override
            public String toString() {
                return WaitHook.super.toString();
            }
        });
    }
}
