package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentPage;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class FluentWaitPageMatcher extends BaseWaitMatcher {
    private final FluentWait wait;
    private final WebDriver webDriver;
    private FluentPage page;

    protected FluentWaitPageMatcher(final FluentWait wait, final WebDriver driver) {
        this.wait = wait;
        this.webDriver = driver;
    }

    protected FluentWaitPageMatcher(final FluentWait wait, final WebDriver driver, final FluentPage page) {
        this.wait = wait;
        this.webDriver = driver;
        this.page = page;
    }

    /**
     * check if the page is loaded or not.
     * Be careful, it needs javascript enabled. Throw an UnsupportedOperationException if not.
     */
    public void isLoaded() {

        if (webDriver instanceof JavascriptExecutor) {
            final Predicate<FluentControl> isLoaded = new Predicate<FluentControl>() {
                public boolean apply(final FluentControl fluent) {
                    final Object result = fluent.executeScript("if (document.readyState) return document.readyState;")
                            .getStringResult();
                    return result != null && "complete".equals(result);
                }
            };
            until(wait, isLoaded, String.format("Page %s should be loaded.", webDriver.getCurrentUrl()));
        } else {
            throw new UnsupportedOperationException("Driver must support javascript execution to use this feature");
        }
    }

    /**
     * check if ou are on the good page calling isAt.
     */
    public void isAt() {
        if (page == null) {
            throw new IllegalArgumentException(
                    "You should use a page argument when you call the untilPage method to specify the page you want to be. "
                            + "Example : await().untilPage(myPage).isAt();");
        }
        final Predicate<FluentControl> isLoaded = new Predicate<FluentControl>() {
            public boolean apply(final FluentControl fluent) {
                try {
                    page.isAt();
                } catch (final Error e) {
                    return false;
                }
                return true;
            }
        };
        until(wait, isLoaded, "");

    }
}
